/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.yggdrasil;

import ch.njol.yggdrasil.Fields;
import ch.njol.yggdrasil.PseudoEnum;
import ch.njol.yggdrasil.Tag;
import ch.njol.yggdrasil.Yggdrasil;
import ch.njol.yggdrasil.YggdrasilException;
import ch.njol.yggdrasil.YggdrasilSerializable;
import ch.njol.yggdrasil.YggdrasilSerializer;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.lang.reflect.Array;
import java.util.IdentityHashMap;
import org.eclipse.jdt.annotation.Nullable;

public abstract class YggdrasilOutputStream
implements Flushable,
Closeable {
    protected final Yggdrasil y;
    private int nextObjectID = 0;
    private final IdentityHashMap<Object, Integer> writtenObjects = new IdentityHashMap();

    protected YggdrasilOutputStream(Yggdrasil y) {
        this.y = y;
    }

    protected abstract void writeTag(Tag var1) throws IOException;

    private final void writeNull() throws IOException {
        this.writeTag(Tag.T_NULL);
    }

    protected abstract void writePrimitiveValue(Object var1) throws IOException;

    protected abstract void writePrimitive_(Object var1) throws IOException;

    private final void writePrimitive(Object o) throws IOException {
        Tag t = Tag.getType(o.getClass());
        assert (t.isWrapper());
        Tag p = t.getPrimitive();
        assert (p != null);
        this.writeTag(p);
        this.writePrimitiveValue(o);
    }

    private final void writeWrappedPrimitive(Object o) throws IOException {
        Tag t = Tag.getType(o.getClass());
        assert (t.isWrapper());
        this.writeTag(t);
        this.writePrimitiveValue(o);
    }

    protected abstract void writeStringValue(String var1) throws IOException;

    private final void writeString(String s) throws IOException {
        this.writeTag(Tag.T_STRING);
        this.writeStringValue(s);
    }

    protected abstract void writeArrayComponentType(Class<?> var1) throws IOException;

    protected abstract void writeArrayLength(int var1) throws IOException;

    protected abstract void writeArrayEnd() throws IOException;

    private final void writeArray(Object array) throws IOException {
        int length = Array.getLength(array);
        Class<?> ct = array.getClass().getComponentType();
        assert (ct != null);
        this.writeTag(Tag.T_ARRAY);
        this.writeArrayComponentType(ct);
        this.writeArrayLength(length);
        if (ct.isPrimitive()) {
            int i = 0;
            while (i < length) {
                Object p = Array.get(array, i);
                assert (p != null);
                this.writePrimitive_(p);
                ++i;
            }
            this.writeArrayEnd();
        } else {
            Object[] objectArray = (Object[])array;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.writeObject(o);
                ++n2;
            }
            this.writeArrayEnd();
        }
    }

    protected abstract void writeEnumType(String var1) throws IOException;

    protected abstract void writeEnumID(String var1) throws IOException;

    private final void writeEnum(Enum<?> o) throws IOException {
        this.writeTag(Tag.T_ENUM);
        Class<?> c = o.getDeclaringClass();
        assert (c != null);
        this.writeEnumType(this.y.getID(c));
        this.writeEnumID(Yggdrasil.getID(o));
    }

    private final void writeEnum(PseudoEnum<?> o) throws IOException {
        this.writeTag(Tag.T_ENUM);
        this.writeEnumType(this.y.getID(o.getDeclaringClass()));
        this.writeEnumID(o.name());
    }

    protected abstract void writeClassType(Class<?> var1) throws IOException;

    private final void writeClass(Class<?> c) throws IOException {
        this.writeTag(Tag.T_CLASS);
        this.writeClassType(c);
    }

    protected abstract void writeReferenceID(int var1) throws IOException;

    protected final void writeReference(int ref) throws IOException {
        assert (ref >= 0);
        this.writeTag(Tag.T_REFERENCE);
        this.writeReferenceID(ref);
    }

    protected abstract void writeObjectType(String var1) throws IOException;

    protected abstract void writeNumFields(short var1) throws IOException;

    protected abstract void writeFieldID(String var1) throws IOException;

    protected abstract void writeObjectEnd() throws IOException;

    private final void writeGenericObject(Object o, int ref) throws IOException {
        Fields fields;
        Class<?> c = o.getClass();
        assert (c != null);
        if (!this.y.isSerializable(c)) {
            throw new NotSerializableException(c.getName());
        }
        YggdrasilSerializer<?> s = this.y.getSerializer(c);
        if (s != null) {
            fields = s.serialize(o);
            if (fields == null) {
                throw new YggdrasilException("The serializer of " + c + " returned null");
            }
            if (!s.canBeInstantiated(c)) {
                this.writtenObjects.put(o, ref ^= 0xFFFFFFFF);
            }
        } else if (o instanceof YggdrasilSerializable.YggdrasilExtendedSerializable) {
            fields = ((YggdrasilSerializable.YggdrasilExtendedSerializable)o).serialize();
            if (fields == null) {
                throw new YggdrasilException("The serialize() method of " + c + " returned null");
            }
        } else {
            fields = new Fields(o);
        }
        if (fields.size() > Short.MAX_VALUE) {
            throw new YggdrasilException("Class " + c.getCanonicalName() + " has too many fields (" + fields.size() + ")");
        }
        this.writeTag(Tag.T_OBJECT);
        this.writeObjectType(this.y.getID(c));
        this.writeNumFields((short)fields.size());
        for (Fields.FieldContext f : fields) {
            this.writeFieldID(f.id);
            if (f.isPrimitive()) {
                this.writePrimitive(f.getPrimitive());
                continue;
            }
            this.writeObject(f.getObject());
        }
        this.writeObjectEnd();
        if (ref < 0) {
            this.writtenObjects.put(o, ~ref);
        }
    }

    public final void writeObject(@Nullable Object o) throws IOException {
        if (o == null) {
            this.writeNull();
            return;
        }
        if (this.writtenObjects.containsKey(o)) {
            int ref = this.writtenObjects.get(o);
            if (ref < 0) {
                throw new YggdrasilException("Uninstantiable object " + o + " is referenced in its fields' graph");
            }
            this.writeReference(ref);
            return;
        }
        int ref = this.nextObjectID++;
        this.writtenObjects.put(o, ref);
        Tag type = Tag.getType(o.getClass());
        if (type.isWrapper()) {
            this.writeWrappedPrimitive(o);
            return;
        }
        switch (type) {
            case T_ARRAY: {
                this.writeArray(o);
                return;
            }
            case T_STRING: {
                this.writeString((String)o);
                return;
            }
            case T_ENUM: {
                if (o instanceof Enum) {
                    this.writeEnum((Enum)o);
                } else {
                    this.writeEnum((PseudoEnum)o);
                }
                return;
            }
            case T_CLASS: {
                this.writeClass((Class)o);
                return;
            }
            case T_OBJECT: {
                this.writeGenericObject(o, ref);
                return;
            }
        }
        throw new YggdrasilException("unhandled type " + (Object)((Object)type));
    }
}

