/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util;

import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value=false)
public abstract class Math2 {
    public static final int min(int a, int b, int c) {
        return a <= b ? (a <= c ? a : c) : (b <= c ? b : c);
    }

    public static int min(int ... nums) {
        if (nums == null || nums.length == 0) {
            assert (false);
            return 0;
        }
        int min = nums[0];
        int i = 1;
        while (i < nums.length) {
            if (nums[i] < min) {
                min = nums[i];
            }
            ++i;
        }
        return min;
    }

    public static final int max(int a, int b, int c) {
        return a >= b ? (a >= c ? a : c) : (b >= c ? b : c);
    }

    public static final int max(int ... nums) {
        if (nums == null || nums.length == 0) {
            assert (false);
            return 0;
        }
        int max = nums[0];
        int i = 1;
        while (i < nums.length) {
            if (nums[i] > max) {
                max = nums[i];
            }
            ++i;
        }
        return max;
    }

    public static final double min(double a, double b, double c) {
        return a <= b ? (a <= c ? a : c) : (b <= c ? b : c);
    }

    public static final double min(double ... nums) {
        if (nums == null || nums.length == 0) {
            assert (false);
            return Double.NaN;
        }
        double min = nums[0];
        int i = 1;
        while (i < nums.length) {
            if (nums[i] < min) {
                min = nums[i];
            }
            ++i;
        }
        return min;
    }

    public static final double max(double a, double b, double c) {
        return a >= b ? (a >= c ? a : c) : (b >= c ? b : c);
    }

    public static final double max(double ... nums) {
        if (nums == null || nums.length == 0) {
            assert (false);
            return Double.NaN;
        }
        double max = nums[0];
        int i = 1;
        while (i < nums.length) {
            if (nums[i] > max) {
                max = nums[i];
            }
            ++i;
        }
        return max;
    }

    public static final int minPositive(int ... nums) {
        int max = -1;
        if (nums != null) {
            int[] nArray = nums;
            int n = nums.length;
            int n2 = 0;
            while (n2 < n) {
                int num = nArray[n2];
                if (num >= 0 && (num < max || max == -1)) {
                    max = num;
                }
                ++n2;
            }
        }
        return max;
    }

    public static final int fit(int min, int x, int max) {
        assert (min <= max) : String.valueOf(min) + "," + x + "," + max;
        return x <= min ? min : (x >= max ? max : x);
    }

    public static final short fit(short min, short x, short max) {
        assert (min <= max) : String.valueOf(min) + "," + x + "," + max;
        return x <= min ? min : (x >= max ? max : x);
    }

    public static final long fit(long min, long x, long max) {
        assert (min <= max) : String.valueOf(min) + "," + x + "," + max;
        return x <= min ? min : (x >= max ? max : x);
    }

    public static final float fit(float min, float x, float max) {
        assert (min <= max) : String.valueOf(min) + "," + x + "," + max;
        return x <= min ? min : (x >= max ? max : x);
    }

    public static final double fit(double min, double x, double max) {
        assert (min <= max) : String.valueOf(min) + "," + x + "," + max;
        return x <= min ? min : (x >= max ? max : x);
    }

    public static final double mod(double d, double m) {
        double r = d % m;
        return r < 0.0 ? r + m : r;
    }

    public static final float mod(float d, float m) {
        float r = d % m;
        return r < 0.0f ? r + m : r;
    }

    public static final int mod(int d, int m) {
        int r = d % m;
        return r < 0 ? r + m : r % m;
    }

    public static final long mod(long d, long m) {
        long r = d % m;
        return r < 0L ? r + m : r % m;
    }

    public static final long floor(double d) {
        return d >= 0.0 ? (long)d : (long)d - 1L;
    }

    public static final long ceil(double d) {
        return -Math2.floor(-d);
    }

    public static final long round(double d) {
        if (d == 0.49999999999999994) {
            return 0L;
        }
        return Math2.floor(d + 0.5);
    }

    public static final int floorI(double d) {
        return d >= 0.0 ? (int)d : (int)d - 1;
    }

    public static final int ceilI(double d) {
        return -Math2.floorI(-d);
    }

    public static final int roundI(double d) {
        if (d == 0.49999999999999994) {
            return 0;
        }
        return Math2.floorI(d + 0.5);
    }

    public static final long floor(float f) {
        return f >= 0.0f ? (long)f : (long)f - 1L;
    }

    public static final long ceil(float f) {
        return -Math2.floor(-f);
    }

    public static final long round(float f) {
        if (f == 0.49999997f) {
            return 0L;
        }
        return Math2.floor(f + 0.5f);
    }

    public static final int floorI(float f) {
        return f >= 0.0f ? (int)f : (int)f - 1;
    }

    public static final int ceilI(float f) {
        return -Math2.floorI(-f);
    }

    public static final int roundI(float f) {
        if (f == 0.49999997f) {
            return 0;
        }
        return Math2.floorI(f + 0.5f);
    }

    public static final int nextPowerOfTwo(int n) {
        assert (n >= 0);
        if ((n & n - 1) == 0) {
            return n;
        }
        return Integer.highestOneBit(n) << 1;
    }

    public static final long nextPowerOfTwo(long n) {
        assert (n >= 0L);
        if ((n & n - 1L) == 0L) {
            return n;
        }
        return Long.highestOneBit(n) << 1;
    }

    public static final double frac(double d) {
        return Math2.mod(d, 1.0);
    }

    public static final float frac(float f) {
        return Math2.mod(f, 1.0f);
    }

    public static final int sign(byte i) {
        return i >> 7 | -i >>> 7;
    }

    public static final int sign(short i) {
        return i >> 15 | -i >>> 15;
    }

    public static final int sign(int i) {
        return i >> 31 | -i >>> 31;
    }

    public static final int sign(long i) {
        return (int)(i >> 63 | -i >>> 63);
    }

    public static final int sign(float f) {
        return f == 0.0f || Float.isNaN(f) ? 0 : (f > 0.0f ? 1 : -1);
    }

    public static final int sign(double d) {
        return d == 0.0 || Double.isNaN(d) ? 0 : (d > 0.0 ? 1 : -1);
    }

    public static final double smoothStep(double x, double x1, double x2) {
        double d = Math2.fit(0.0, (x - x1) / (x2 - x1), 1.0);
        return d * d * (3.0 - 2.0 * d);
    }
}

