/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.util.Utils;
import ch.njol.skript.variables.Variables;
import ch.njol.util.StringUtils;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;

final class VariablesMap {
    static final Comparator<String> variableNameComparator = new Comparator<String>(){

        @Override
        public int compare(@Nullable String s1, @Nullable String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            int i = 0;
            int j = 0;
            while (i < s1.length() && j < s2.length()) {
                char c1 = s1.charAt(i);
                char c2 = s2.charAt(j);
                if ('0' <= c1 && c1 <= '9' && '0' <= c2 && c2 <= '9') {
                    int n2;
                    int i2 = StringUtils.findLastDigit(s1, i);
                    int j2 = StringUtils.findLastDigit(s2, j);
                    int n1 = Utils.parseInt(s1.substring(i, i2));
                    if (n1 > (n2 = Utils.parseInt(s2.substring(j, j2)))) {
                        return 1;
                    }
                    if (n1 < n2) {
                        return -1;
                    }
                    i = i2;
                    j = j2;
                    continue;
                }
                if (c1 > c2) {
                    return 1;
                }
                if (c1 < c2) {
                    return -1;
                }
                ++i;
                ++j;
            }
            if (i < s1.length()) {
                return -1;
            }
            if (j < s2.length()) {
                return 1;
            }
            return 0;
        }
    };
    final HashMap<String, Object> hashMap = new HashMap();
    final TreeMap<String, Object> treeMap = new TreeMap();

    VariablesMap() {
    }

    @Nullable
    final Object getVariable(String name) {
        if (!name.endsWith("*")) {
            return this.hashMap.get(name);
        }
        String[] split = Variables.splitVariableName(name);
        Map<String, Object> current = this.treeMap;
        int i = 0;
        while (i < split.length) {
            String n = split[i];
            if (n.equals("*")) {
                assert (i == split.length - 1);
                return current;
            }
            Object o = current.get(n);
            if (o == null) {
                return null;
            }
            if (o instanceof Map) {
                current = (Map)o;
                assert (i != split.length - 1);
            } else {
                return null;
            }
            ++i;
        }
        return null;
    }

    final void setVariable(String name, @Nullable Object value) {
        if (!name.endsWith("*")) {
            if (value == null) {
                this.hashMap.remove(name);
            } else {
                this.hashMap.put(name, value);
            }
        }
        Object[] split = Variables.splitVariableName(name);
        TreeMap<String, Object> parent = this.treeMap;
        int i = 0;
        while (i < split.length) {
            String n = split[i];
            TreeMap<String, Object> current = parent.get(n);
            if (current == null) {
                if (i == split.length - 1) {
                    if (value == null) break;
                    parent.put(n, value);
                    break;
                }
                if (value == null) break;
                current = new TreeMap<String, Object>(variableNameComparator);
                parent.put(n, current);
                parent = current;
            } else if (current instanceof TreeMap) {
                if (i == split.length - 1) {
                    if (value == null) {
                        ((TreeMap)current).remove(null);
                        break;
                    }
                    ((TreeMap)current).put(null, value);
                    break;
                }
                if (i == split.length - 2 && split[i + 1].equals("*")) {
                    assert (value == null);
                    this.deleteFromHashMap(StringUtils.join(split, "::", 0, i + 1), current);
                    Object v = current.get(null);
                    if (v == null) {
                        parent.remove(n);
                        break;
                    }
                    parent.put(n, v);
                    break;
                }
                parent = current;
            } else {
                if (i == split.length - 1) {
                    if (value == null) {
                        parent.remove(n);
                        break;
                    }
                    parent.put(n, value);
                    break;
                }
                if (value == null) break;
                TreeMap<String, TreeMap<String, Object>> c = new TreeMap<String, TreeMap<String, Object>>(variableNameComparator);
                c.put(null, current);
                parent.put(n, c);
                parent = c;
            }
            ++i;
        }
    }

    void deleteFromHashMap(String parent, TreeMap<String, Object> current) {
        for (Map.Entry<String, Object> e : current.entrySet()) {
            if (e.getKey() == null) continue;
            this.hashMap.remove(String.valueOf(parent) + "::" + e.getKey());
            Object val = e.getValue();
            if (!(val instanceof TreeMap)) continue;
            this.deleteFromHashMap(String.valueOf(parent) + "::" + e.getKey(), (TreeMap)val);
        }
    }
}

