/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.ConfigurationSerializer;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.variables.DatabaseStorage;
import ch.njol.skript.variables.FlatFileStorage;
import ch.njol.skript.variables.SerializedVariable;
import ch.njol.skript.variables.VariablesMap;
import ch.njol.skript.variables.VariablesStorage;
import ch.njol.util.Closeable;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import ch.njol.yggdrasil.Yggdrasil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Variables {
    public static final short YGGDRASIL_VERSION = 1;
    public static final Yggdrasil yggdrasil = new Yggdrasil(1);
    private static final String configurationSerializablePrefix = "ConfigurationSerializable_";
    static List<VariablesStorage> storages;
    private static final Pattern variableNameSplitPattern;
    private static final ReadWriteLock variablesLock;
    private static final VariablesMap variables;
    private static final WeakHashMap<Event, VariablesMap> localVariables;
    @Nullable
    private static Map<String, NonNullPair<Object, VariablesStorage>> tempVars;
    static final BlockingQueue<SerializedVariable> queue;
    static volatile boolean closed;
    private static final Thread saveThread;

    static {
        yggdrasil.registerSingleClass(Kleenean.class, "Kleenean");
        yggdrasil.registerClassResolver(new ConfigurationSerializer<ConfigurationSerializable>(){
            {
                this.info = Classes.getExactClassInfo(Object.class);
            }

            @Override
            @Nullable
            public String getID(Class<?> c) {
                if (ConfigurationSerializable.class.isAssignableFrom(c) && Classes.getSuperClassInfo(c) == Classes.getExactClassInfo(Object.class)) {
                    return Variables.configurationSerializablePrefix + ConfigurationSerialization.getAlias(c);
                }
                return null;
            }

            @Override
            @Nullable
            public Class<? extends ConfigurationSerializable> getClass(String id) {
                if (id.startsWith(Variables.configurationSerializablePrefix)) {
                    return ConfigurationSerialization.getClassByAlias((String)id.substring(Variables.configurationSerializablePrefix.length()));
                }
                return null;
            }
        });
        storages = new ArrayList<VariablesStorage>();
        variableNameSplitPattern = Pattern.compile(Pattern.quote("::"));
        variablesLock = new ReentrantReadWriteLock(true);
        variables = new VariablesMap();
        localVariables = new WeakHashMap();
        tempVars = new HashMap<String, NonNullPair<Object, VariablesStorage>>();
        queue = new LinkedBlockingQueue<SerializedVariable>();
        closed = false;
        saveThread = Skript.newThread(new Runnable(){

            @Override
            public void run() {
                block2: while (!closed) {
                    try {
                        SerializedVariable v = queue.take();
                        for (VariablesStorage s : storages) {
                            if (!s.accept(v.name)) continue;
                            s.save(v);
                            continue block2;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }, "Skript variable save thread");
    }

    private Variables() {
    }

    public static boolean load() {
        assert (Variables.variables.treeMap.isEmpty());
        assert (Variables.variables.hashMap.isEmpty());
        assert (storages.isEmpty());
        Config c = SkriptConfig.getConfig();
        if (c == null) {
            throw new SkriptAPIException("Cannot load variables before the config");
        }
        Node databases = c.getMainNode().get("databases");
        if (databases == null || !(databases instanceof SectionNode)) {
            Skript.error("The config is missing the required 'databases' section that defines where the variables are saved");
            return false;
        }
        Skript.closeOnDisable(new Closeable(){

            @Override
            public void close() {
                Variables.close();
            }
        });
        try {
            boolean successful = true;
            for (Node node : (SectionNode)databases) {
                if (node instanceof SectionNode) {
                    VariablesStorage s;
                    SectionNode n = (SectionNode)node;
                    String type = n.getValue("type");
                    if (type == null) {
                        Skript.error("Missing entry 'type' in database definition");
                        successful = false;
                        continue;
                    }
                    String name = n.getKey();
                    assert (name != null);
                    if (type.equalsIgnoreCase("csv") || type.equalsIgnoreCase("file") || type.equalsIgnoreCase("flatfile")) {
                        s = new FlatFileStorage(name);
                    } else if (type.equalsIgnoreCase("mysql")) {
                        s = new DatabaseStorage(name, DatabaseStorage.Type.MYSQL);
                    } else if (type.equalsIgnoreCase("sqlite")) {
                        s = new DatabaseStorage(name, DatabaseStorage.Type.SQLITE);
                    } else {
                        if (type.equalsIgnoreCase("disabled") || type.equalsIgnoreCase("none")) continue;
                        Skript.error("Invalid database type '" + type + "'");
                        successful = false;
                        continue;
                    }
                    if (s.load(n)) {
                        storages.add(s);
                        continue;
                    }
                    successful = false;
                    continue;
                }
                Skript.error("Invalid line in databases: databases must be defined as sections");
                successful = false;
            }
            if (!successful) {
                return false;
            }
            if (storages.isEmpty()) {
                Skript.error("No databases to store variables are defined. Please enable at least the default database, even if you don't use variables at all.");
                return false;
            }
        }
        finally {
            int n = Variables.onStoragesLoaded();
            if (n != 0) {
                Skript.warning(String.valueOf(n) + " variables were possibly discarded due to not belonging to any database (SQL databases keep such variables and will continue to generate this warning, while CSV discards them).");
            }
        }
        saveThread.start();
        return true;
    }

    public static final String[] splitVariableName(String name) {
        return variableNameSplitPattern.split(name);
    }

    static TreeMap<String, Object> getVariables() {
        return Variables.variables.treeMap;
    }

    static Map<String, Object> getVariablesHashMap() {
        return Collections.unmodifiableMap(Variables.variables.hashMap);
    }

    static Lock getReadLock() {
        return variablesLock.readLock();
    }

    @Nullable
    public static final Object getVariable(String name, @Nullable Event e, boolean local) {
        if (local) {
            VariablesMap map = localVariables.get(e);
            if (map == null) {
                return null;
            }
            return map.getVariable(name);
        }
        try {
            variablesLock.readLock().lock();
            Object object = variables.getVariable(name);
            return object;
        }
        finally {
            variablesLock.readLock().unlock();
        }
    }

    public static final void setVariable(String name, @Nullable Object value, @Nullable Event e, boolean local) {
        if (value != null) {
            assert (!name.endsWith("::*"));
            ClassInfo<?> ci = Classes.getSuperClassInfo(value.getClass());
            Class<?> sas = ci.getSerializeAs();
            if (sas != null) {
                value = Converters.convert(value, sas);
                assert (value != null) : ci + ", " + sas;
            }
        }
        if (local) {
            assert (e != null) : name;
            VariablesMap map = localVariables.get(e);
            if (map == null) {
                map = new VariablesMap();
                localVariables.put(e, map);
            }
            map.setVariable(name, value);
        } else {
            Variables.setVariable(name, value);
        }
    }

    static final void setVariable(String name, @Nullable Object value) {
        try {
            variablesLock.writeLock().lock();
            variables.setVariable(name, value);
        }
        finally {
            variablesLock.writeLock().unlock();
        }
        Variables.saveVariableChange(name, value);
    }

    static final boolean variableLoaded(String name, @Nullable Object value, VariablesStorage source) {
        assert (Bukkit.isPrimaryThread());
        Map<String, NonNullPair<Object, VariablesStorage>> tvs = tempVars;
        if (tvs != null) {
            if (value == null) {
                return false;
            }
            NonNullPair<Object, VariablesStorage> v = tvs.get(name);
            if (v != null && v.second != source) {
                Skript.warning("The variable {" + name + "} was loaded twice from different databases (" + ((VariablesStorage)v.second).databaseName + " and " + source.databaseName + "), only the one from " + source.databaseName + " will be kept.");
                ((VariablesStorage)v.second).save(name, null, null);
            }
            tvs.put(name, new NonNullPair<Object, VariablesStorage>(value, source));
            return false;
        }
        variablesLock.writeLock().lock();
        try {
            variables.setVariable(name, value);
        }
        finally {
            variablesLock.writeLock().unlock();
        }
        for (VariablesStorage s : storages) {
            if (!s.accept(name)) continue;
            if (s != source) {
                SerializedVariable.Value v = Variables.serialize(value);
                s.save(name, v != null ? v.type : null, v != null ? v.data : null);
                if (value != null) {
                    source.save(name, null, null);
                }
            }
            return true;
        }
        return false;
    }

    private static int onStoragesLoaded() {
        Map<String, NonNullPair<Object, VariablesStorage>> tvs = tempVars;
        tempVars = null;
        assert (tvs != null);
        int n = 0;
        for (Map.Entry<String, NonNullPair<Object, VariablesStorage>> tv : tvs.entrySet()) {
            if (Variables.variableLoaded(tv.getKey(), tv.getValue().first, (VariablesStorage)tv.getValue().second)) continue;
            ++n;
        }
        return n;
    }

    public static final SerializedVariable serialize(String name, @Nullable Object value) {
        assert (Bukkit.isPrimaryThread());
        SerializedVariable.Value var = Variables.serialize(value);
        return new SerializedVariable(name, var);
    }

    @Nullable
    public static final SerializedVariable.Value serialize(@Nullable Object value) {
        assert (Bukkit.isPrimaryThread());
        return Classes.serialize(value);
    }

    private static final void saveVariableChange(String name, @Nullable Object value) {
        queue.add(Variables.serialize(name, value));
    }

    public static void close() {
        while (queue.size() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        closed = true;
        saveThread.interrupt();
    }

    public static int numVariables() {
        try {
            variablesLock.readLock().lock();
            int n = Variables.variables.hashMap.size();
            return n;
        }
        finally {
            variablesLock.readLock().unlock();
        }
    }
}

