/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.util.Direction;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.iterator.SingleItemIterator;
import ch.njol.yggdrasil.YggdrasilSerializable;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;

public final class VisualEffect
implements SyntaxElement,
YggdrasilSerializable {
    private static final String LANGUAGE_NODE = "visual effects";
    private static final String TYPE_ID = "VisualEffect.Type";
    @Nullable
    static SyntaxElementInfo<VisualEffect> info;
    static final List<Type> types;
    static final Noun[] names;
    private Type type;
    @Nullable
    private Object data;

    static {
        Variables.yggdrasil.registerSingleClass(Type.class, TYPE_ID);
        Variables.yggdrasil.registerSingleClass(Effect.class, "Bukkit_Effect");
        Variables.yggdrasil.registerSingleClass(EntityEffect.class, "Bukkit_EntityEffect");
        types = new ArrayList<Type>(Type.values().length);
        names = new Noun[Type.values().length];
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                Type[] ts = Type.values();
                types.clear();
                ArrayList<String> patterns = new ArrayList<String>(ts.length);
                int i = 0;
                while (i < ts.length) {
                    String node = "visual effects." + ts[i].name();
                    String pattern = Language.get_(String.valueOf(node) + ".pattern");
                    if (pattern == null) {
                        if (Skript.testing()) {
                            Skript.warning("Missing pattern at '" + node + ".pattern" + "' in the " + Language.getName() + " language file");
                        }
                    } else {
                        types.add(ts[i]);
                        patterns.add(pattern);
                    }
                    if (names[i] == null) {
                        VisualEffect.names[i] = new Noun(String.valueOf(node) + ".name");
                    }
                    ++i;
                }
                String[] ps = patterns.toArray(new String[patterns.size()]);
                if (!$assertionsDisabled && ps == null) {
                    throw new AssertionError();
                }
                info = new SyntaxElementInfo<VisualEffect>(ps, VisualEffect.class);
            }
        });
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = types.get(matchedPattern);
        assert (exprs.length <= 1);
        this.data = exprs.length == 0 || exprs[0] == null ? null : exprs[0].getSingle(null);
        return true;
    }

    public boolean isEntityEffect() {
        return this.type.effect instanceof EntityEffect;
    }

    @Nullable
    public static final VisualEffect parse(String s) {
        SyntaxElementInfo<VisualEffect> info = VisualEffect.info;
        if (info == null) {
            return null;
        }
        return SkriptParser.parseStatic(Noun.stripIndefiniteArticle(s), new SingleItemIterator<SyntaxElementInfo<VisualEffect>>(info), null);
    }

    public void play(@Nullable Player[] ps, Location l, @Nullable Entity e) {
        assert (e == null || l.equals((Object)e.getLocation()));
        if (this.isEntityEffect()) {
            if (e != null) {
                e.playEffect((EntityEffect)this.type.effect);
            }
        } else if (ps == null) {
            l.getWorld().playEffect(l, (Effect)this.type.effect, this.type.getData(this.data, l));
        } else {
            Player[] playerArray = ps;
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                p.playEffect(l, (Effect)this.type.effect, this.type.getData(this.data, l));
                ++n2;
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int flags) {
        return names[this.type.ordinal()].toString(flags);
    }

    public static String getAllNames() {
        return StringUtils.join(names, ", ");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        Object d = this.data;
        result = 31 * result + (d == null ? 0 : d.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualEffect)) {
            return false;
        }
        VisualEffect other = (VisualEffect)obj;
        if (this.type != other.type) {
            return false;
        }
        Object d = this.data;
        return !(d == null ? other.data != null : !d.equals(other.data));
    }

    private static class Type
    extends Enum<Type>
    implements YggdrasilSerializable {
        public static final /* enum */ Type ENDER_SIGNAL = new Type(Effect.ENDER_SIGNAL);
        public static final /* enum */ Type MOBSPAWNER_FLAMES = new Type(Effect.MOBSPAWNER_FLAMES);
        public static final /* enum */ Type POTION_BREAK = new Type(Effect.POTION_BREAK){

            @Override
            public Object getData(@Nullable Object raw, Location l) {
                return new PotionEffect(raw == null ? PotionEffectType.SPEED : (PotionEffectType)raw, 1, 0);
            }
        };
        public static final /* enum */ Type SMOKE = new Type(Effect.SMOKE){

            @Override
            public Object getData(@Nullable Object raw, Location l) {
                if (raw == null) {
                    return BlockFace.SELF;
                }
                return Direction.getFacing(((Direction)raw).getDirection(l), false);
            }
        };
        public static final /* enum */ Type HURT = new Type(EntityEffect.HURT);
        public static final /* enum */ Type SHEEP_EAT = new Type(EntityEffect.SHEEP_EAT);
        public static final /* enum */ Type WOLF_HEARTS = new Type(EntityEffect.WOLF_HEARTS);
        public static final /* enum */ Type WOLF_SHAKE = new Type(EntityEffect.WOLF_SHAKE);
        public static final /* enum */ Type WOLF_SMOKE = new Type(EntityEffect.WOLF_SMOKE);
        final Object effect;
        private static final /* synthetic */ Type[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Type[]{ENDER_SIGNAL, MOBSPAWNER_FLAMES, POTION_BREAK, SMOKE, HURT, SHEEP_EAT, WOLF_HEARTS, WOLF_SHAKE, WOLF_SMOKE};
        }

        private Type(Object effect) {
            assert (effect instanceof Effect || effect instanceof EntityEffect);
            this.effect = effect;
        }

        @Nullable
        public Object getData(@Nullable Object raw, Location l) {
            assert (raw == null);
            return null;
        }

        public static Type[] values() {
            Type[] typeArray = ENUM$VALUES;
            int n = typeArray.length;
            Type[] typeArray2 = new Type[n];
            System.arraycopy(ENUM$VALUES, 0, typeArray2, 0, n);
            return typeArray2;
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

