/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.eclipse.jdt.annotation.Nullable;

public abstract class PotionEffectUtils {
    static final Map<String, PotionEffectType> types = new HashMap<String, PotionEffectType>();
    static final String[] names = new String[PotionEffectUtils.getMaxPotionId() + 1];

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                types.clear();
                PotionEffectType[] potionEffectTypeArray = PotionEffectType.values();
                int n = potionEffectTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PotionEffectType t = potionEffectTypeArray[n2];
                    if (t != null) {
                        String[] ls = Language.getList("potions." + t.getName());
                        PotionEffectUtils.names[t.getId()] = ls[0];
                        String[] stringArray = ls;
                        int n3 = ls.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String l = stringArray[n4];
                            types.put(l.toLowerCase(), t);
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    private PotionEffectUtils() {
    }

    private static final int getMaxPotionId() {
        int i = 0;
        PotionEffectType[] potionEffectTypeArray = PotionEffectType.values();
        int n = potionEffectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PotionEffectType t = potionEffectTypeArray[n2];
            if (t != null && t.getId() > i) {
                i = t.getId();
            }
            ++n2;
        }
        return i;
    }

    @Nullable
    public static PotionEffectType parseType(String s) {
        return types.get(s.toLowerCase());
    }

    public static String toString(PotionEffectType t) {
        return names[t.getId()];
    }

    public static String toString(PotionEffectType t, int flags) {
        return names[t.getId()];
    }

    public static final String[] getNames() {
        return names;
    }

    public static short guessData(ThrownPotion p) {
        if (p.getEffects().size() == 1) {
            PotionEffect e = (PotionEffect)p.getEffects().iterator().next();
            Potion d = new Potion(PotionType.getByEffect((PotionEffectType)e.getType())).splash();
            return d.toDamageValue();
        }
        return 0;
    }
}

