/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value=false)
public class BlockStateBlock
implements Block {
    final BlockState state;
    private final boolean delayChanges;

    public BlockStateBlock(BlockState state) {
        assert (state != null);
        this.state = state;
        this.delayChanges = false;
    }

    public BlockStateBlock(BlockState state, boolean delayChanges) {
        assert (state != null);
        this.state = state;
        this.delayChanges = delayChanges;
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.state.setMetadata(metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.state.getMetadata(metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.state.hasMetadata(metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.state.removeMetadata(metadataKey, owningPlugin);
    }

    public byte getData() {
        return this.state.getRawData();
    }

    public Block getRelative(int modX, int modY, int modZ) {
        return this.state.getBlock().getRelative(modX, modY, modZ);
    }

    public Block getRelative(BlockFace face) {
        return this.state.getBlock().getRelative(face);
    }

    public Block getRelative(BlockFace face, int distance) {
        return this.state.getBlock().getRelative(face, distance);
    }

    public Material getType() {
        return this.state.getType();
    }

    public int getTypeId() {
        return this.state.getTypeId();
    }

    public byte getLightLevel() {
        return this.state.getLightLevel();
    }

    public byte getLightFromSky() {
        return this.state.getBlock().getLightFromSky();
    }

    public byte getLightFromBlocks() {
        return this.state.getBlock().getLightFromBlocks();
    }

    public World getWorld() {
        return this.state.getWorld();
    }

    public int getX() {
        return this.state.getX();
    }

    public int getY() {
        return this.state.getY();
    }

    public int getZ() {
        return this.state.getZ();
    }

    public Location getLocation() {
        return this.state.getLocation();
    }

    public Chunk getChunk() {
        return this.state.getChunk();
    }

    public void setData(final byte data) {
        if (this.delayChanges) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    BlockStateBlock.this.state.getBlock().setData(data);
                }
            });
        } else {
            this.state.setRawData(data);
        }
    }

    public void setData(final byte data, final boolean applyPhysics) {
        if (this.delayChanges) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    BlockStateBlock.this.state.getBlock().setData(data, applyPhysics);
                }
            });
        } else {
            this.state.setRawData(data);
        }
    }

    public void setType(final Material type) {
        if (this.delayChanges) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    BlockStateBlock.this.state.getBlock().setType(type);
                }
            });
        } else {
            this.state.setType(type);
        }
    }

    public boolean setTypeId(final int type) {
        if (this.delayChanges) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    BlockStateBlock.this.state.getBlock().setTypeId(type);
                }
            });
            return true;
        }
        int id = this.getTypeId();
        this.state.setTypeId(type);
        return id != type;
    }

    public boolean setTypeId(final int type, final boolean applyPhysics) {
        if (this.delayChanges) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    BlockStateBlock.this.state.getBlock().setTypeId(type, applyPhysics);
                }
            });
            return true;
        }
        int id = this.getTypeId();
        this.state.setTypeId(type);
        return id != type;
    }

    public boolean setTypeIdAndData(final int type, final byte data, final boolean applyPhysics) {
        if (this.delayChanges) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    BlockStateBlock.this.state.getBlock().setTypeIdAndData(type, data, applyPhysics);
                }
            });
            return true;
        }
        int id = this.getTypeId();
        byte d = this.getData();
        this.state.setTypeId(type);
        this.state.setRawData(data);
        return id != type || d != data;
    }

    public BlockFace getFace(Block block) {
        return this.state.getBlock().getFace(block);
    }

    public BlockState getState() {
        return this.state;
    }

    public Biome getBiome() {
        return this.state.getBlock().getBiome();
    }

    public void setBiome(Biome bio) {
        this.state.getBlock().setBiome(bio);
    }

    public boolean isBlockPowered() {
        return this.state.getBlock().isBlockPowered();
    }

    public boolean isBlockIndirectlyPowered() {
        return this.state.getBlock().isBlockIndirectlyPowered();
    }

    public boolean isBlockFacePowered(BlockFace face) {
        return this.state.getBlock().isBlockFacePowered(face);
    }

    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        return this.state.getBlock().isBlockFaceIndirectlyPowered(face);
    }

    public int getBlockPower(BlockFace face) {
        return this.state.getBlock().getBlockPower(face);
    }

    public int getBlockPower() {
        return this.state.getBlock().getBlockPower();
    }

    public boolean isEmpty() {
        return this.getTypeId() == 0;
    }

    public boolean isLiquid() {
        return this.getType() == Material.WATER || this.getType() == Material.STATIONARY_WATER || this.getType() == Material.LAVA || this.getType() == Material.STATIONARY_LAVA;
    }

    public double getTemperature() {
        return this.state.getBlock().getTemperature();
    }

    public double getHumidity() {
        return this.state.getBlock().getHumidity();
    }

    public PistonMoveReaction getPistonMoveReaction() {
        throw new UnsupportedOperationException();
    }

    public boolean breakNaturally() {
        if (this.delayChanges) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    BlockStateBlock.this.state.getBlock().breakNaturally();
                }
            });
            return true;
        }
        return false;
    }

    public boolean breakNaturally(final ItemStack tool) {
        if (this.delayChanges) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    BlockStateBlock.this.state.getBlock().breakNaturally(tool);
                }
            });
            return true;
        }
        return false;
    }

    public Collection<ItemStack> getDrops() {
        assert (false);
        return Collections.emptySet();
    }

    public Collection<ItemStack> getDrops(ItemStack tool) {
        assert (false);
        return Collections.emptySet();
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX((double)this.getX());
            loc.setY((double)this.getY());
            loc.setZ((double)this.getZ());
            loc.setPitch(0.0f);
            loc.setYaw(0.0f);
        }
        return loc;
    }
}

