/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.SkriptLogger;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.eclipse.jdt.annotation.Nullable;

public class RedirectingLogHandler
extends LogHandler {
    @Nullable
    private final CommandSender recipient;
    private final String prefix;
    private int numErrors = 0;

    public RedirectingLogHandler(CommandSender recipient, @Nullable String prefix) {
        this.recipient = recipient == Bukkit.getConsoleSender() ? null : recipient;
        this.prefix = prefix == null ? "" : prefix;
    }

    @Override
    public LogHandler.LogResult log(LogEntry entry) {
        if (this.recipient != null) {
            this.recipient.sendMessage(String.valueOf(this.prefix) + entry.toString());
        } else {
            SkriptLogger.LOGGER.log(entry.getLevel(), String.valueOf(this.prefix) + entry.toString());
        }
        if (entry.level == Level.SEVERE) {
            ++this.numErrors;
        }
        return LogHandler.LogResult.DONT_LOG;
    }

    public int numErrors() {
        return this.numErrors;
    }
}

