/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.Skript;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.SkriptLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.Nullable;

public class ParseLogHandler
extends LogHandler {
    @Nullable
    private LogEntry error = null;
    private final List<LogEntry> log = new ArrayList<LogEntry>();
    boolean printedErrorOrLog = false;

    @Override
    public LogHandler.LogResult log(LogEntry entry) {
        if (entry.getLevel() == Level.SEVERE) {
            LogEntry e = this.error;
            if (e == null || entry.getQuality() > e.getQuality()) {
                this.error = entry;
                if (e != null) {
                    e.discarded();
                }
            }
        } else {
            this.log.add(entry);
        }
        return LogHandler.LogResult.CACHED;
    }

    @Override
    public void onStop() {
        if (!this.printedErrorOrLog && Skript.testing()) {
            SkriptLogger.LOGGER.warning("Parse log wasn't instructed to print anything at " + SkriptLogger.getCaller());
        }
    }

    public void error(String error, ErrorQuality quality) {
        this.log(new LogEntry(SkriptLogger.SEVERE, quality, error));
    }

    public void clear() {
        for (LogEntry e : this.log) {
            e.discarded();
        }
        this.log.clear();
    }

    public void printLog() {
        this.printedErrorOrLog = true;
        this.stop();
        SkriptLogger.logAll(this.log);
        if (this.error != null) {
            this.error.discarded();
        }
    }

    public void printError() {
        this.printError(null);
    }

    public void printError(@Nullable String def) {
        this.printedErrorOrLog = true;
        this.stop();
        if (this.error != null) {
            SkriptLogger.log(this.error);
        } else if (def != null) {
            SkriptLogger.log(new LogEntry(SkriptLogger.SEVERE, def));
        }
        for (LogEntry e : this.log) {
            e.discarded();
        }
    }

    public int getNumErrors() {
        return this.error == null ? 0 : 1;
    }

    public boolean hasError() {
        return this.error != null;
    }

    @Nullable
    public LogEntry getError() {
        return this.error;
    }
}

