/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.Node;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.SkriptLogger;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.Nullable;

public class LogEntry {
    public final Level level;
    public int quality;
    public String message;
    @Nullable
    private final Node node;
    @Nullable
    private final String from;
    private boolean tracked = false;
    private static final String skriptLogPackageName = SkriptLogger.class.getPackage().getName();
    private boolean used = false;

    public LogEntry(Level level, String message) {
        this(level, ErrorQuality.SEMANTIC_ERROR.quality(), message, SkriptLogger.getNode());
    }

    public LogEntry(Level level, int quality, String message) {
        this(level, quality, message, SkriptLogger.getNode());
    }

    public LogEntry(Level level, ErrorQuality quality, String message) {
        this(level, quality.quality(), message, SkriptLogger.getNode());
    }

    public LogEntry(Level level, String message, @Nullable Node node) {
        this(level, ErrorQuality.SEMANTIC_ERROR.quality(), message, node);
    }

    public LogEntry(Level level, ErrorQuality quality, String message, Node node) {
        this(level, quality.quality(), message, node);
    }

    public LogEntry(Level level, int quality, String message, @Nullable Node node) {
        this(level, quality, message, node, false);
    }

    public LogEntry(Level level, int quality, String message, @Nullable Node node, boolean tracked) {
        this.level = level;
        this.quality = quality;
        this.message = message;
        this.node = node;
        this.tracked = tracked;
        this.from = tracked || Skript.debug() ? LogEntry.findCaller() : "";
    }

    static String findCaller() {
        StackTraceElement[] es = new Exception().getStackTrace();
        int i = 0;
        while (i < es.length) {
            if (es[i].getClassName().startsWith(skriptLogPackageName)) {
                ++i;
                while (i < es.length - 1 && (es[i].getClassName().startsWith(skriptLogPackageName) || es[i].getClassName().equals(Skript.class.getName()))) {
                    ++i;
                }
                if (i >= es.length) {
                    i = es.length - 1;
                }
                return " (from " + es[i] + ")";
            }
            ++i;
        }
        return " (from an unknown source)";
    }

    public Level getLevel() {
        return this.level;
    }

    public int getQuality() {
        return this.quality;
    }

    public String getMessage() {
        return this.toString();
    }

    void discarded() {
        this.used = true;
        if (this.tracked) {
            SkriptLogger.LOGGER.warning(" # LogEntry '" + this.message + "'" + this.from + " discarded" + LogEntry.findCaller());
        }
    }

    void logged() {
        this.used = true;
        if (this.tracked) {
            SkriptLogger.LOGGER.warning(" # LogEntry '" + this.message + "'" + this.from + " logged" + LogEntry.findCaller());
        }
    }

    protected void finalize() throws Throwable {
        assert (this.used) : String.valueOf(this.message) + this.from;
    }

    public String toString() {
        Node n = this.node;
        if (n == null || this.level.intValue() < Level.WARNING.intValue()) {
            return this.message;
        }
        Config c = n.getConfig();
        return String.valueOf(this.message) + this.from + " (" + c.getFileName() + ", line " + n.getLine() + ": " + n.save().trim() + "')";
    }
}

