/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="UUID")
@Description(value={"The UUID of a player or world.", "In the future there will be an option to use a player's UUID instead of the name in variable names (i.e. when %player% is used), but for now this can be used.", "<em>Please note that this expression does not work for offline players!</em>"})
@Examples(value={"# prevents people from joining the server if they use the name of a player", "# who has played on this server at least once since this script has been added", "on login:", "\t{uuids.%name of player%} exists:", "\t\t{uuids.%name of player%} is not UUID of player", "\t\tkick player due to \"Someone with your name has played on this server before\"", "\telse:", "\t\tset {uuids.%name of player%} to UUID of player"})
@Since(value="2.1.2")
public class ExprUUID
extends SimplePropertyExpression<Object, String> {
    static {
        ExprUUID.register(ExprUUID.class, String.class, "UUID", "players/worlds");
    }

    @Override
    @Nullable
    public String convert(Object o) {
        if (o instanceof Player) {
            return ((Player)o).getUniqueId().toString();
        }
        if (o instanceof World) {
            return ((World)o).getUID().toString();
        }
        return null;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return "UUID";
    }
}

