/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.EquipmentSlot;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.InventorySlot;
import ch.njol.skript.util.Slot;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Tool")
@Description(value={"The item a player is holding."})
@Examples(value={"player is holding a pickaxe", "# is the same as", "player's tool is a pickaxe"})
@Since(value="1.0")
public class ExprTool
extends PropertyExpression<LivingEntity, Slot> {
    static {
        Skript.registerExpression(ExprTool.class, Slot.class, ExpressionType.PROPERTY, "[the] (tool|held item|weapon) [of %livingentities%]", "%livingentities%'[s] (tool|held item|weapon)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Slot[] get(final Event e, LivingEntity[] source) {
        final boolean delayed = Delay.isDelayed(e);
        return this.get(source, new Getter<Slot, LivingEntity>(){

            @Override
            public Slot get(LivingEntity p) {
                if (!delayed) {
                    if (e instanceof PlayerItemHeldEvent && ((PlayerItemHeldEvent)e).getPlayer() == p) {
                        PlayerInventory i = ((PlayerItemHeldEvent)e).getPlayer().getInventory();
                        if (!$assertionsDisabled && i == null) {
                            throw new AssertionError();
                        }
                        return new InventorySlot((Inventory)i, ExprTool.this.getTime() >= 0 ? ((PlayerItemHeldEvent)e).getNewSlot() : ((PlayerItemHeldEvent)e).getPreviousSlot());
                    }
                    if (e instanceof PlayerBucketEvent && ((PlayerBucketEvent)e).getPlayer() == p) {
                        PlayerInventory i = ((PlayerBucketEvent)e).getPlayer().getInventory();
                        if (!$assertionsDisabled && i == null) {
                            throw new AssertionError();
                        }
                        return new InventorySlot((Inventory)i, ((PlayerBucketEvent)e).getPlayer().getInventory().getHeldItemSlot()){

                            @Override
                            @Nullable
                            public ItemStack getItem() {
                                return ExprTool.this.getTime() <= 0 ? super.getItem() : ((PlayerBucketEvent)e).getItemStack();
                            }

                            @Override
                            public void setItem(@Nullable ItemStack item) {
                                if (ExprTool.this.getTime() >= 0) {
                                    ((PlayerBucketEvent)e).setItemStack(item);
                                } else {
                                    super.setItem(item);
                                }
                            }
                        };
                    }
                }
                EntityEquipment e2 = p.getEquipment();
                if (!$assertionsDisabled && e2 == null) {
                    throw new AssertionError();
                }
                return new EquipmentSlot(e2, EquipmentSlot.EquipSlot.TOOL){

                    @Override
                    public String toString_i() {
                        return "the " + (ExprTool.this.getTime() == 1 ? "future " : (ExprTool.this.getTime() == -1 ? "former " : "")) + super.toString_i();
                    }
                };
            }
        });
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the " + (this.getTime() == 1 ? "future " : (this.getTime() == -1 ? "former " : "")) + "tool of " + this.getExpr().toString(e, debug);
        }
        return Classes.getDebugMessage(this.getSingle(e));
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), PlayerItemHeldEvent.class, PlayerBucketFillEvent.class, PlayerBucketEmptyEvent.class);
    }
}

