/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Level")
@Description(value={"The level of a player."})
@Examples(value={"reduce the victim's level by 1", "set the player's level to 0"})
@Since(value="")
public class ExprLevel
extends SimplePropertyExpression<Player, Integer> {
    static {
        ExprLevel.register(ExprLevel.class, Integer.class, "level", "players");
    }

    protected Integer[] get(final Event e, Player[] source) {
        return super.get(source, new Converter<Player, Integer>(){

            @Override
            public Integer convert(Player p) {
                if (e instanceof PlayerLevelChangeEvent && ((PlayerLevelChangeEvent)e).getPlayer() == p && !Delay.isDelayed(e)) {
                    return ExprLevel.this.getTime() < 0 ? ((PlayerLevelChangeEvent)e).getOldLevel() : ((PlayerLevelChangeEvent)e).getNewLevel();
                }
                return p.getLevel();
            }
        });
    }

    @Override
    @Nullable
    public Integer convert(Player p) {
        assert (false);
        return null;
    }

    @Override
    public Class<Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return null;
        }
        if (ScriptLoader.isCurrentEvent(PlayerRespawnEvent.class) && !ScriptLoader.hasDelayBefore.isTrue()) {
            Skript.error("Cannot change a player's level in a respawn event. Add a delay of 1 tick or change the 'new level' in a death event.");
            return null;
        }
        if (ScriptLoader.isCurrentEvent(PlayerDeathEvent.class) && this.getTime() == 0 && this.getExpr().isDefault() && !ScriptLoader.hasDelayBefore.isTrue()) {
            Skript.warning("Changing the player's level in a death event will change the player's level before he dies. Use either 'past level of player' or 'new level of player' to clearly state whether to change the level before or after he dies.");
        }
        if (this.getTime() == -1 && !ScriptLoader.isCurrentEvent(PlayerDeathEvent.class)) {
            return null;
        }
        return new Class[]{Number.class};
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (mode != Changer.ChangeMode.REMOVE_ALL);
        int l = delta == null ? 0 : ((Number)delta[0]).intValue();
        Player[] playerArray = (Player[])this.getExpr().getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                Player p = playerArray[n2];
                int level = this.getTime() > 0 && e instanceof PlayerDeathEvent && ((PlayerDeathEvent)e).getEntity() == p && !Delay.isDelayed(e) ? ((PlayerDeathEvent)e).getNewLevel() : p.getLevel();
                switch (mode) {
                    case SET: {
                        level = l;
                        break;
                    }
                    case ADD: {
                        level += l;
                        break;
                    }
                    case REMOVE: {
                        level -= l;
                        break;
                    }
                    case DELETE: 
                    case RESET: {
                        level = 0;
                        break;
                    }
                    case REMOVE_ALL: {
                        assert (false);
                        break block12;
                    }
                }
                if (this.getTime() > 0 && e instanceof PlayerDeathEvent && ((PlayerDeathEvent)e).getEntity() == p && !Delay.isDelayed(e)) {
                    ((PlayerDeathEvent)e).setNewLevel(level);
                } else {
                    p.setLevel(level);
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), PlayerLevelChangeEvent.class, PlayerDeathEvent.class);
    }

    @Override
    protected String getPropertyName() {
        return "level";
    }
}

