/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.ExpressionType;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="IP")
@Description(value={"The IP address of a player."})
@Examples(value={"IP-ban the player # is equal to the next line", "ban the IP-address of the player", "broadcast \"Banned the IP %IP of player%\""})
@Since(value="1.4")
public class ExprIP
extends SimplePropertyExpression<Player, String> {
    static {
        Skript.registerExpression(ExprIP.class, String.class, ExpressionType.PROPERTY, "IP[s][( |-)address[es]] of %players%", "%players%'[s] IP[s][( |-)address[es]]");
    }

    @Override
    @Nullable
    public String convert(Player p) {
        return p.getAddress().getAddress().getHostAddress();
    }

    @Override
    public Class<String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return "IP address" + (this.getExpr().isSingle() ? "" : "es");
    }
}

