/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Hash")
@Description(value={"Hashes the given text using the MD5 algorithm. This is useful for storing passwords or IP addresses without having to store them literally.", "Please note that an MD5 hash is irreversible, i.e. you won't be able to get the original text back (which is the point of storing passwords like this). Brute-force attacks can still be performed on hashes though which can easily crack short or insecure passwords."})
@Examples(value={"command /setpass <text>:", "\ttrigger:", "\t\tset {password.%player%} to hashed text-argument", "command /login <text>:", "\ttrigger:", "\t\t{password.%player%} is hashed text-argument:", "\t\t\tmessage \"login successful.\"", "\t\telse:", "\t\t\tmessage \"wrong password!\""})
@Since(value="2.0")
public class ExprHash
extends PropertyExpression<String, String> {
    @Nullable
    static MessageDigest md5;

    static {
        Skript.registerExpression(ExprHash.class, String.class, ExpressionType.PROPERTY, "[md5]( |-)hash(ed|[( |-|)code] of) %strings%");
        md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("JVM does not adhere to Java specifications");
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (md5 == null) {
            Skript.error("The Java Virtual Machine running on this server does not support the MD5 algorithm, thus you cannot use the 'hash' expression.");
            return false;
        }
        this.setExpr(exprs[0]);
        return true;
    }

    protected String[] get(Event e, String[] source) {
        assert (md5 != null);
        String[] r = new String[source.length];
        int i = 0;
        while (i < r.length) {
            r[i] = ExprHash.toHex(md5.digest(source[i].getBytes(StandardCharsets.UTF_8)));
            ++i;
        }
        return r;
    }

    private static String toHex(byte[] b) {
        char[] r = new char[2 * b.length];
        int i = 0;
        while (i < b.length) {
            r[2 * i] = Character.forDigit((b[i] & 0xF0) >> 4, 16);
            r[2 * i + 1] = Character.forDigit(b[i] & 0xF, 16);
            ++i;
        }
        return new String(r);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "hash of " + this.getExpr();
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }
}

