/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@NoDoc
public class ExprEventCancelled
extends SimpleExpression<Boolean> {
    private Kleenean delay;

    static {
        Skript.registerExpression(ExprEventCancelled.class, Boolean.class, ExpressionType.SIMPLE, "[is] event cancelled");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.delay = isDelayed;
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Nullable
    protected Boolean[] get(Event e) {
        if (!(e instanceof Cancellable)) {
            return new Boolean[0];
        }
        return new Boolean[]{((Cancellable)e).isCancelled()};
    }

    @Override
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "is event cancelled";
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.delay != Kleenean.FALSE) {
            Skript.error("Can't cancel the event anymore after it has already passed");
            return null;
        }
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return CollectionUtils.array(Boolean.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (!(e instanceof Cancellable)) {
            return;
        }
        switch (mode) {
            case DELETE: {
                ((Cancellable)e).setCancelled(false);
                break;
            }
            case SET: {
                assert (delta != null);
                ((Cancellable)e).setCancelled(((Boolean)delta[0]).booleanValue());
            }
        }
    }
}

