/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Compass Target")
@Description(value={"The location a player's compass is pointing at."})
@Examples(value={"# make all player's compasses target a player stored in {compass target.%player%}", "every 5 seconds:", "\tloop all players:", "\t\tset the loop-player's compass target to location of {compass target.%loop-player%}"})
@Since(value="2.0")
public class ExprCompassTarget
extends SimplePropertyExpression<Player, Location> {
    static {
        ExprCompassTarget.register(ExprCompassTarget.class, Location.class, "compass target", "players");
    }

    @Override
    @Nullable
    public Location convert(Player p) {
        return p.getCompassTarget();
    }

    @Override
    public Class<Location> getReturnType() {
        return Location.class;
    }

    @Override
    protected String getPropertyName() {
        return "compass target";
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return new Class[]{Location.class};
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        Player[] playerArray = (Player[])this.getExpr().getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            p.setCompassTarget(delta == null ? p.getWorld().getSpawnLocation() : (Location)delta[0]);
            ++n2;
        }
    }
}

