/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Checker;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.eclipse.jdt.annotation.Nullable;

public class EvtClick
extends SkriptEvent {
    private static final int RIGHT = 1;
    private static final int LEFT = 2;
    private static final int ANY = 3;
    @Nullable
    private Literal<?> types = null;
    @Nullable
    private Literal<ItemType> tools;
    private int click = 3;

    static {
        Skript.registerEvent("Click", EvtClick.class, CollectionUtils.array(PlayerInteractEvent.class, PlayerInteractEntityEvent.class), "[(1\u00a6right|2\u00a6left)(| |-)][mouse(| |-)]click[ing] [on %-entitydata/itemtype%] [(with|using|holding) %itemtype%]", "[(1\u00a6right|2\u00a6left)(| |-)][mouse(| |-)]click[ing] (with|using|holding) %itemtype% on %entitydata/itemtype%").description("Called when a user clicks on a block, an entity or air with or without an item in their hand.", "Please note that rightclick events with an empty hand while not looking at a block are not sent to the server, so there's no way to detect them.").examples("on click", "on rightclick holding a fishing rod", "on leftclick on a stone or obsidian", "on rightclick on a creeper", "on click with a sword").since("1.0");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.click = parser.mark == 0 ? 3 : parser.mark;
        this.types = args[matchedPattern];
        if (this.types != null && !ItemType.class.isAssignableFrom(this.types.getReturnType())) {
            if (this.click == 2) {
                Skript.error("A leftclick on an entity is an attack and thus not covered by the 'click' event, but the 'damage' event.", ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
            if (this.click == 3) {
                Skript.warning("A leftclick on an entity is an attack and thus not covered by the 'click' event, but the 'damage' event. Change this event to a rightclick to disable this warning message.");
            }
        }
        this.tools = args[1 - matchedPattern];
        return true;
    }

    @Override
    public boolean check(Event e) {
        Block block;
        Entity entity;
        Player player;
        if (e instanceof PlayerInteractEntityEvent) {
            if (this.click == 2 || this.types == null) {
                return false;
            }
            player = ((PlayerInteractEntityEvent)e).getPlayer();
            entity = ((PlayerInteractEntityEvent)e).getRightClicked();
            block = null;
        } else if (e instanceof PlayerInteractEvent) {
            int click;
            Action a = ((PlayerInteractEvent)e).getAction();
            switch (a) {
                case LEFT_CLICK_BLOCK: 
                case LEFT_CLICK_AIR: {
                    click = 2;
                    break;
                }
                case RIGHT_CLICK_BLOCK: 
                case RIGHT_CLICK_AIR: {
                    click = 1;
                    break;
                }
                default: {
                    return false;
                }
            }
            if ((this.click & click) == 0) {
                return false;
            }
            player = ((PlayerInteractEvent)e).getPlayer();
            block = ((PlayerInteractEvent)e).getClickedBlock();
            entity = null;
        } else {
            assert (false);
            return false;
        }
        if (this.tools != null && !this.tools.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(player.getItemInHand());
            }
        })) {
            return false;
        }
        if (this.types != null) {
            return this.types.check(e, new Checker<Object>(){

                @Override
                public boolean check(Object o) {
                    if (entity != null) {
                        return o instanceof EntityData ? ((EntityData)o).isInstance(entity) : Comparator.Relation.EQUAL.is(DefaultComparators.entityItemComparator.compare(EntityData.fromEntity(entity), (ItemType)o));
                    }
                    return o instanceof EntityData ? false : ((ItemType)o).isOfType(block);
                }
            });
        }
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.click == 2 ? "left" : (this.click == 1 ? "right" : "")) + "click" + (this.types != null ? " on " + this.types.toString(e, debug) : "") + (this.tools != null ? " holding " + this.tools.toString(e, debug) : "");
    }
}

