/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="op/deop")
@Description(value={"Grant/revoke a user operator status."})
@Examples(value={"op the player", "deop all players"})
@Since(value="1.0")
public class EffOp
extends Effect {
    private Expression<OfflinePlayer> players;
    private boolean op;

    static {
        Skript.registerEffect(EffOp.class, "[de[-]]op %offlineplayers%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.op = !parseResult.expr.substring(0, 2).equalsIgnoreCase("de");
        return true;
    }

    @Override
    protected void execute(Event e) {
        OfflinePlayer[] offlinePlayerArray = this.players.getArray(e);
        int n = offlinePlayerArray.length;
        int n2 = 0;
        while (n2 < n) {
            OfflinePlayer p = offlinePlayerArray[n2];
            p.setOp(this.op);
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.op ? "" : "de") + "op " + this.players.toString(e, debug);
    }
}

