/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Testable;
import ch.njol.util.Kleenean;
import org.bukkit.Material;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Equip")
@Description(value={"Equips a player with some given armor. This will replace any armor that the player is wearing."})
@Examples(value={"equip player with diamond helmet", "equip player with all diamond armor"})
@Since(value="1.0")
public class EffEquip
extends Effect
implements Testable {
    private Expression<LivingEntity> entities;
    private Expression<ItemType> types;

    static {
        Skript.registerEffect(EffEquip.class, "equip [%livingentity%] with %itemtypes%", "make %livingentity% wear %itemtypes%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.entities = vars[0];
        this.types = vars[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        ItemType[] ts = this.types.getArray(e);
        LivingEntity[] livingEntityArray = this.entities.getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType t;
            int n3;
            ItemType[] itemTypeArray;
            LivingEntity en = livingEntityArray[n2];
            if (en instanceof Pig) {
                itemTypeArray = ts;
                n3 = ts.length;
                int n4 = 0;
                while (n4 < n3) {
                    t = itemTypeArray[n4];
                    if (t.isOfType(Material.SADDLE.getId(), (short)0)) {
                        ((Pig)en).setSaddle(true);
                        break;
                    }
                    ++n4;
                }
            } else if (Skript.isRunningMinecraft(1, 6) && en instanceof Horse) {
                HorseInventory invi = ((Horse)en).getInventory();
                ItemType[] itemTypeArray2 = ts;
                int n5 = ts.length;
                n3 = 0;
                while (n3 < n5) {
                    ItemType t2 = itemTypeArray2[n3];
                    for (ItemStack item : t2.getAll()) {
                        if (item.getType() == Material.SADDLE) {
                            invi.setSaddle(item);
                            continue;
                        }
                        if (item.getType() == Material.IRON_BARDING || item.getType() == Material.GOLD_BARDING || item.getType() == Material.DIAMOND_BARDING) {
                            invi.setArmor(item);
                            continue;
                        }
                        if (item.getType() != Material.CHEST) continue;
                        ((Horse)en).setCarryingChest(true);
                    }
                    ++n3;
                }
            } else if (en.getEquipment() != null) {
                itemTypeArray = ts;
                n3 = ts.length;
                int n6 = 0;
                while (n6 < n3) {
                    t = itemTypeArray[n6];
                    block11: for (ItemStack item : t.getAll()) {
                        switch (item.getType()) {
                            case LEATHER_BOOTS: 
                            case CHAINMAIL_BOOTS: 
                            case IRON_BOOTS: 
                            case DIAMOND_BOOTS: 
                            case GOLD_BOOTS: {
                                en.getEquipment().setBoots(item);
                                break;
                            }
                            case LEATHER_LEGGINGS: 
                            case CHAINMAIL_LEGGINGS: 
                            case IRON_LEGGINGS: 
                            case DIAMOND_LEGGINGS: 
                            case GOLD_LEGGINGS: {
                                en.getEquipment().setLeggings(item);
                                break;
                            }
                            case LEATHER_CHESTPLATE: 
                            case CHAINMAIL_CHESTPLATE: 
                            case IRON_CHESTPLATE: 
                            case DIAMOND_CHESTPLATE: 
                            case GOLD_CHESTPLATE: {
                                en.getEquipment().setChestplate(item);
                                break;
                            }
                            default: {
                                if (!item.getType().isBlock() && item.getTypeId() != 397) continue block11;
                            }
                            case LEATHER_HELMET: 
                            case CHAINMAIL_HELMET: 
                            case IRON_HELMET: 
                            case DIAMOND_HELMET: 
                            case GOLD_HELMET: {
                                en.getEquipment().setHelmet(item);
                            }
                        }
                    }
                    ++n6;
                }
                if (en instanceof Player) {
                    PlayerUtils.updateInventory((Player)en);
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean test(Event e) {
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "equip " + this.entities.toString(e, debug) + " with " + this.types.toString(e, debug);
    }
}

