/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.doc;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.conditions.CondCompare;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Callback;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.IteratorIterable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

@SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
public class Documentation {
    public static final boolean generate = Skript.testing() && new File(Skript.getInstance().getDataFolder(), "generate-doc").exists();
    private static ArrayList<Pattern> validation = new ArrayList();
    private static final String[] urls;

    static {
        validation.add(Pattern.compile("<(?!a href='|/a>|br ?/|/?(i|b|u|code|pre|ul|li|em)>)"));
        validation.add(Pattern.compile("(?<!</a|'|br ?/|/?(i|b|u|code|pre|ul|li|em))>"));
        urls = new String[]{"expressions", "effects", "conditions"};
    }

    public static final void generate() {
        if (!generate) {
            return;
        }
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(Skript.getInstance().getDataFolder(), "doc.sql")), "UTF-8"));
            Documentation.asSql(pw);
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }
    }

    private static final void asSql(PrintWriter pw) {
        pw.println("-- syntax elements");
        pw.println("UPDATE syntax_elements SET patterns='';");
        pw.println();
        pw.println("-- expressions");
        for (ExpressionInfo<?, ?> expressionInfo : new IteratorIterable(Skript.getExpressions())) {
            assert (expressionInfo != null);
            Documentation.insertSyntaxElement(pw, expressionInfo, "expression");
        }
        pw.println();
        pw.println("-- effects");
        for (SyntaxElementInfo syntaxElementInfo : Skript.getEffects()) {
            assert (syntaxElementInfo != null);
            Documentation.insertSyntaxElement(pw, syntaxElementInfo, "effect");
        }
        pw.println();
        pw.println("-- conditions");
        for (SyntaxElementInfo syntaxElementInfo : Skript.getConditions()) {
            assert (syntaxElementInfo != null);
            Documentation.insertSyntaxElement(pw, syntaxElementInfo, "condition");
        }
        pw.println();
        pw.println("-- events");
        for (SkriptEventInfo skriptEventInfo : Skript.getEvents()) {
            assert (skriptEventInfo != null);
            Documentation.insertEvent(pw, skriptEventInfo);
        }
        pw.println();
        pw.println();
        pw.println("-- classes");
        pw.println("UPDATE classes SET patterns='';");
        pw.println();
        for (ClassInfo classInfo : Classes.getClassInfos()) {
            String since;
            if (classInfo.getDocName() == ClassInfo.NO_DOC) continue;
            if (classInfo.getDocName() == null || classInfo.getDescription() == null || classInfo.getUsage() == null || classInfo.getExamples() == null || classInfo.getSince() == null) {
                Skript.warning("Class " + classInfo.getCodeName() + " is missing information");
                continue;
            }
            String desc = Documentation.validateHTML(StringUtils.join(classInfo.getDescription(), "<br/>"), "classes");
            String usage = Documentation.validateHTML(StringUtils.join(classInfo.getUsage(), "<br/>"), "classes");
            String string = since = classInfo.getSince() == null ? "" : Documentation.validateHTML(classInfo.getSince(), "classes");
            if (desc == null || usage == null || since == null) {
                Skript.warning("Class " + classInfo.getCodeName() + "'s description, usage or 'since' is invalid");
                continue;
            }
            String patterns = classInfo.getUserInputPatterns() == null ? "" : Documentation.convertRegex(StringUtils.join(classInfo.getUserInputPatterns(), "\n"));
            Documentation.insertOnDuplicateKeyUpdate(pw, "classes", "id, name, description, patterns, `usage`, examples, since", "patterns = TRIM(LEADING '\n' FROM CONCAT(patterns, '\n', '" + Documentation.escapeSQL(patterns) + "'))", Documentation.escapeHTML(classInfo.getCodeName()), Documentation.escapeHTML(classInfo.getDocName()), desc, patterns, usage, Documentation.escapeHTML(StringUtils.join(classInfo.getExamples(), "\n")), since);
        }
    }

    private static final String convertRegex(String regex) {
        if (StringUtils.containsAny(regex, ".[]\\*+")) {
            Skript.error("Regex '" + regex + "' contains unconverted Regex syntax");
        }
        return Documentation.escapeHTML(regex.replaceAll("\\((.+?)\\)\\?", "[$1]").replaceAll("(.)\\?", "[$1]"));
    }

    private static final String cleanPatterns(String patterns) {
        String s = StringUtils.replaceAll((CharSequence)Documentation.escapeHTML(patterns).replaceAll("(?<=[\\(\\|]).+?\u00a6", "").replace("()", "").replaceAll("\\(([^|]+?)\\|\\)", "[$1]").replaceAll("\\(\\|([^|]+?)\\)", "[$1]").replaceAll("\\((.+?)\\|\\)", "[($1)]").replaceAll("\\(\\|(.+?)\\)", "[($1)]"), "(?<!\\\\)%(.+?)(?<!\\\\)%", new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                int a;
                String s = m.group(1);
                if (s.startsWith("-")) {
                    s = s.substring(1);
                }
                String flag = "";
                if (s.startsWith("*") || s.startsWith("~")) {
                    flag = s.substring(0, 1);
                    s = s.substring(1);
                }
                if ((a = s.indexOf("@")) != -1) {
                    s = s.substring(0, a);
                }
                StringBuilder b = new StringBuilder("%");
                b.append(flag);
                boolean first = true;
                String[] stringArray = s.split("/");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String c = stringArray[n2];
                    if (!$assertionsDisabled && c == null) {
                        throw new AssertionError();
                    }
                    if (!first) {
                        b.append("/");
                    }
                    first = false;
                    NonNullPair<String, Boolean> p = Utils.getEnglishPlural(c);
                    ClassInfo<?> ci = Classes.getClassInfoNoError((String)p.first);
                    if (ci != null && ci.getDocName() != null && ci.getDocName() != ClassInfo.NO_DOC) {
                        b.append("<a href='../classes/#").append((String)p.first).append("'>").append(ci.getName().toString((Boolean)p.second)).append("</a>");
                    } else {
                        b.append(c);
                        if (ci != null && ci.getDocName() != ClassInfo.NO_DOC) {
                            Skript.warning("Used class " + (String)p.first + " has no docName/name defined");
                        }
                    }
                    ++n2;
                }
                return b.append("%").toString();
            }
        });
        assert (s != null) : patterns;
        return s;
    }

    private static final void insertSyntaxElement(PrintWriter pw, SyntaxElementInfo<?> info, String type) {
        if (info.c.getAnnotation(NoDoc.class) != null) {
            return;
        }
        if (info.c.getAnnotation(Name.class) == null || info.c.getAnnotation(Description.class) == null || info.c.getAnnotation(Examples.class) == null || info.c.getAnnotation(Since.class) == null) {
            Skript.warning(info.c.getSimpleName() + " is missing information");
            return;
        }
        String desc = Documentation.validateHTML(StringUtils.join(info.c.getAnnotation(Description.class).value(), "<br/>"), String.valueOf(type) + "s");
        String since = Documentation.validateHTML(info.c.getAnnotation(Since.class).value(), String.valueOf(type) + "s");
        if (desc == null || since == null) {
            Skript.warning(info.c.getSimpleName() + "'s description or 'since' is invalid");
            return;
        }
        String patterns = Documentation.cleanPatterns(StringUtils.join(info.patterns, "\n", 0, info.c == CondCompare.class ? 8 : info.patterns.length));
        Documentation.insertOnDuplicateKeyUpdate(pw, "syntax_elements", "id, name, type, patterns, description, examples, since", "patterns = TRIM(LEADING '\n' FROM CONCAT(patterns, '\n', '" + Documentation.escapeSQL(patterns) + "'))", Documentation.escapeHTML(info.c.getSimpleName()), Documentation.escapeHTML(info.c.getAnnotation(Name.class).value()), type, patterns, desc, Documentation.escapeHTML(StringUtils.join(info.c.getAnnotation(Examples.class).value(), "\n")), since);
    }

    private static final void insertEvent(PrintWriter pw, SkriptEventInfo<?> info) {
        if (info.getDescription() == SkriptEventInfo.NO_DOC) {
            return;
        }
        if (info.getDescription() == null || info.getExamples() == null || info.getSince() == null) {
            Skript.warning(info.getName() + " (" + info.c.getSimpleName() + ") is missing information");
            return;
        }
        for (SkriptEventInfo<?> i : Skript.getEvents()) {
            if (!info.getId().equals(i.getId()) || info == i || i.getDescription() == null || i.getDescription() == SkriptEventInfo.NO_DOC) continue;
            Skript.warning("Duplicate event id '" + info.getId() + "'");
            return;
        }
        String desc = Documentation.validateHTML(StringUtils.join(info.getDescription(), "<br/>"), "events");
        String since = Documentation.validateHTML(info.getSince(), "events");
        if (desc == null || since == null) {
            Skript.warning("description or 'since' of " + info.getName() + " (" + info.c.getSimpleName() + ") is invalid");
            return;
        }
        String patterns = Documentation.cleanPatterns(info.getName().startsWith("On ") ? "[on] " + StringUtils.join(info.patterns, "\n[on] ") : StringUtils.join(info.patterns, "\n"));
        Documentation.insertOnDuplicateKeyUpdate(pw, "syntax_elements", "id, name, type, patterns, description, examples, since", "patterns = '" + Documentation.escapeSQL(patterns) + "'", Documentation.escapeHTML(info.getId()), Documentation.escapeHTML(info.getName()), "event", patterns, desc, Documentation.escapeHTML(StringUtils.join(info.getExamples(), "\n")), since);
    }

    private static final void insertOnDuplicateKeyUpdate(PrintWriter pw, String table, String fields, String update, String ... values) {
        int i = 0;
        while (i < values.length) {
            String v = values[i];
            assert (v != null);
            values[i] = Documentation.escapeSQL(v);
            ++i;
        }
        pw.println("INSERT INTO " + table + " (" + fields + ") VALUES ('" + StringUtils.join(values, "','") + "') ON DUPLICATE KEY UPDATE " + update + ";");
    }

    @Nullable
    private static final String validateHTML(@Nullable String html, String baseURL) {
        if (html == null) {
            assert (false);
            return null;
        }
        for (Pattern p : validation) {
            if (!p.matcher(html).find()) continue;
            return null;
        }
        html = html.replaceAll("&(?!(amp|lt|gt|quot);)", "&amp;");
        Matcher m = Pattern.compile("<a href='(.*?)'>").matcher(html);
        block3: while (m.find()) {
            String url = m.group(1);
            String[] s = url.split("#");
            if (s.length == 1) continue;
            if (s[0].isEmpty()) {
                s[0] = "../" + baseURL + "/";
            }
            if (s[0].startsWith("../") && s[0].endsWith("/")) {
                if (s[0].equals("../classes/")) {
                    if (Classes.getClassInfoNoError(s[1]) != null) {
                        continue;
                    }
                } else if (s[0].equals("../events/")) {
                    for (SkriptEventInfo<?> i : Skript.getEvents()) {
                        if (s[1].equals(i.getId())) continue block3;
                    }
                } else {
                    int i = CollectionUtils.indexOf(urls, s[0].substring("../".length(), s[0].length() - 1));
                    if (i != -1) {
                        try {
                            Class.forName("ch.njol.skript." + urls[i] + "." + s[1]);
                            continue;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
            }
            Skript.warning("invalid link '" + url + "' found in '" + html + "'");
        }
        return html;
    }

    private static final String escapeSQL(String s) {
        return s.replace("'", "\\'").replace("\"", "\\\"");
    }

    public static final String escapeHTML(@Nullable String s) {
        if (s == null) {
            assert (false);
            return "";
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }
}

