/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config;

import ch.njol.skript.config.Config;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.VoidNode;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Node {
    @Nullable
    protected String key;
    protected String comment = "";
    protected final int lineNum;
    private final boolean debug;
    @Nullable
    protected SectionNode parent;
    protected Config config;
    private static final Pattern linePattern = Pattern.compile("^((?:[^#]|##)*)(#(?!#).*)$");

    protected Node(Config c) {
        this.key = null;
        this.debug = false;
        this.lineNum = -1;
        this.config = c;
        SkriptLogger.setNode(this);
    }

    protected Node(String key, SectionNode parent) {
        this.key = key;
        this.debug = false;
        this.lineNum = -1;
        this.parent = parent;
        this.config = parent.getConfig();
        SkriptLogger.setNode(this);
    }

    protected Node(String key, String comment, SectionNode parent, int lineNum) {
        this.key = key;
        assert (comment.isEmpty() || comment.startsWith("#")) : comment;
        this.comment = comment;
        this.debug = comment.equals("#DEBUG#");
        this.lineNum = lineNum;
        this.parent = parent;
        this.config = parent.getConfig();
        SkriptLogger.setNode(this);
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    public final Config getConfig() {
        return this.config;
    }

    public void rename(String newname) {
        if (this.key == null) {
            throw new IllegalStateException("can't rename an anonymous node");
        }
        String oldKey = this.key;
        this.key = newname;
        if (this.parent != null) {
            this.parent.renamed(this, oldKey);
        }
    }

    public void move(SectionNode newParent) {
        SectionNode p = this.parent;
        if (p == null) {
            throw new IllegalStateException("can't move the main node");
        }
        p.remove(this);
        newParent.add(this);
    }

    public static final NonNullPair<String, String> splitLine(String line) {
        Matcher m = linePattern.matcher(line);
        if (m.matches()) {
            return new NonNullPair<String, String>(m.group(1).replace("##", "#"), m.group(2));
        }
        return new NonNullPair<String, String>(line.replace("##", "#"), "");
    }

    @Nullable
    protected String getComment() {
        return this.comment;
    }

    int getLevel() {
        int l = 0;
        Node n = this;
        while ((n = n.parent) != null) {
            ++l;
        }
        return Math.max(0, l - 1);
    }

    protected String getIndentation() {
        return StringUtils.multiply(this.config.getIndentation(), this.getLevel());
    }

    abstract String save_i();

    public final String save() {
        return String.valueOf(this.getIndentation()) + this.save_i().replace("#", "##") + this.comment;
    }

    public void save(PrintWriter w) {
        w.println(this.save());
    }

    @Nullable
    public SectionNode getParent() {
        return this.parent;
    }

    public void remove() {
        SectionNode p = this.parent;
        if (p == null) {
            return;
        }
        p.remove(this);
    }

    public int getLine() {
        return this.lineNum;
    }

    public boolean isVoid() {
        return this instanceof VoidNode;
    }

    public String toString() {
        if (this.parent == null) {
            return this.config.getFileName();
        }
        return String.valueOf(this.save_i()) + this.comment + " (" + this.config.getFileName() + ", " + (this.lineNum == -1 ? "unknown line" : "line " + this.lineNum) + ")";
    }

    public boolean debug() {
        return this.debug;
    }
}

