/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.config;

import ch.njol.skript.Skript;
import ch.njol.skript.config.ConfigReader;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.Option;
import ch.njol.skript.config.OptionSection;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.eclipse.jdt.annotation.Nullable;

public class Config {
    boolean simple = false;
    private String indentation = "\t";
    private String indentationName = "tab";
    final String defaultSeparator;
    String separator;
    String line = "";
    int level = 0;
    private final SectionNode main;
    int errors = 0;
    final boolean allowEmptySections;
    String fileName;
    @Nullable
    File file = null;

    public Config(InputStream source, String fileName, boolean simple, boolean allowEmptySections, String defaultSeparator) throws IOException {
        try {
            this.fileName = fileName;
            this.simple = simple;
            this.allowEmptySections = allowEmptySections;
            this.defaultSeparator = defaultSeparator;
            this.separator = defaultSeparator;
            if (source.available() == 0) {
                this.main = new SectionNode(this);
                Skript.warning("'" + this.getFileName() + "' is empty");
                return;
            }
            if (Skript.logVeryHigh()) {
                Skript.info("loading '" + fileName + "'");
            }
            ConfigReader r = new ConfigReader(source);
            try {
                this.main = SectionNode.load(this, r);
            }
            finally {
                r.close();
            }
        }
        finally {
            source.close();
        }
    }

    public Config(File file, boolean simple, boolean allowEmptySections, String defaultSeparator) throws IOException {
        this(new FileInputStream(file), file.getName(), simple, allowEmptySections, defaultSeparator);
        this.file = file;
    }

    public Config(String s, String fileName, boolean simple, boolean allowEmptySections, String defaultSeparator) throws IOException {
        this(new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)), fileName, simple, allowEmptySections, defaultSeparator);
    }

    void setIndentation(String indent) {
        assert (indent != null && indent.length() > 0) : indent;
        this.indentation = indent;
        this.indentationName = indent.charAt(0) == ' ' ? "space" : "tab";
    }

    String getIndentation() {
        return this.indentation;
    }

    String getIndentationName() {
        return this.indentationName;
    }

    public SectionNode getMainNode() {
        return this.main;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void save(File f) throws IOException {
        this.separator = this.defaultSeparator;
        PrintWriter w = new PrintWriter(f, "UTF-8");
        try {
            this.main.save(w);
        }
        finally {
            w.flush();
            w.close();
        }
    }

    public boolean setValues(Config other) {
        return this.getMainNode().setValues(other.getMainNode(), new String[0]);
    }

    public boolean setValues(Config other, String ... excluded) {
        return this.getMainNode().setValues(other.getMainNode(), excluded);
    }

    @Nullable
    public File getFile() {
        return this.file;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getSaveSeparator() {
        if (this.separator.equals(":")) {
            return ": ";
        }
        if (this.separator.equals("=")) {
            return " = ";
        }
        return " " + this.separator + " ";
    }

    @Nullable
    public String getByPath(String path) {
        return this.get(path.split("\\."));
    }

    @Nullable
    public String get(String ... path) {
        SectionNode section = this.main;
        int i = 0;
        while (i < path.length) {
            Node n = section.get(path[i]);
            if (n == null) {
                return null;
            }
            if (n instanceof SectionNode) {
                if (i == path.length - 1) {
                    return null;
                }
            } else {
                if (n instanceof EntryNode && i == path.length - 1) {
                    return ((EntryNode)n).getValue();
                }
                return null;
            }
            section = (SectionNode)n;
            ++i;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.main.isEmpty();
    }

    public HashMap<String, String> toMap(String separator) {
        return this.main.toMap("", separator);
    }

    public boolean validate(SectionValidator validator) {
        return validator.validate(this.getMainNode());
    }

    private void load(Class<?> c, @Nullable Object o, String path) {
        Field[] fieldArray = c.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                Field f = fieldArray[n2];
                f.setAccessible(true);
                if (o != null || Modifier.isStatic(f.getModifiers())) {
                    try {
                        if (OptionSection.class.isAssignableFrom(f.getType())) {
                            Object p = f.get(o);
                            Class<?> pc = p.getClass();
                            this.load(pc, p, String.valueOf(path) + ((OptionSection)p).key + ".");
                        } else if (Option.class.isAssignableFrom(f.getType())) {
                            ((Option)f.get(o)).set(this, path);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        assert (false);
                    }
                    catch (IllegalAccessException e) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError();
                    }
                }
            }
            ++n2;
        }
    }

    public void load(Object o) {
        this.load(o.getClass(), o, "");
    }

    public void load(Class<?> c) {
        this.load(c, null, "");
    }
}

