/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.Skript;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Utils;
import ch.njol.util.StringUtils;
import ch.njol.util.Validate;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.help.GenericCommandHelpTopic;
import org.bukkit.help.HelpMap;
import org.bukkit.help.HelpTopic;
import org.bukkit.help.HelpTopicComparator;
import org.bukkit.help.IndexHelpTopic;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class ScriptCommand
implements CommandExecutor {
    public static final Message m_executable_by_players = new Message("commands.executable by players");
    public static final Message m_executable_by_console = new Message("commands.executable by console");
    final String name;
    private final String label;
    private final List<String> aliases;
    private List<String> activeAliases;
    private final String permission;
    private final String permissionMessage;
    private final String description;
    final String usage;
    final Trigger trigger;
    private final String pattern;
    private final List<Argument<?>> arguments;
    public static final int PLAYERS = 1;
    public static final int CONSOLE = 2;
    public static final int BOTH = 3;
    final int executableBy;
    private transient PluginCommand bukkitCommand;
    @Nullable
    private transient Command overridden = null;
    private transient Map<String, Command> overriddenAliases = new HashMap<String, Command>();
    private transient Collection<HelpTopic> helps = new ArrayList<HelpTopic>();

    public ScriptCommand(File script, String name, String pattern, List<Argument<?>> arguments, String description, String usage, ArrayList<String> aliases, String permission, String permissionMessage, int executableBy, List<TriggerItem> items) {
        Validate.notNull(name, pattern, arguments, description, usage, aliases, items);
        this.name = name;
        this.label = name.toLowerCase();
        this.permission = permission;
        this.permissionMessage = permissionMessage.isEmpty() ? Language.get("commands.no permission message") : Utils.replaceEnglishChatStyles(permissionMessage);
        Iterator<String> as = aliases.iterator();
        while (as.hasNext()) {
            if (!as.next().equalsIgnoreCase(this.label)) continue;
            as.remove();
        }
        this.aliases = aliases;
        this.activeAliases = new ArrayList<String>(aliases);
        this.description = Utils.replaceEnglishChatStyles(description);
        this.usage = Utils.replaceEnglishChatStyles(usage);
        this.executableBy = executableBy;
        this.pattern = pattern;
        this.arguments = arguments;
        this.trigger = new Trigger(script, "command /" + name, new SimpleEvent(), items);
        this.bukkitCommand = this.setupBukkitCommand();
    }

    private PluginCommand setupBukkitCommand() {
        try {
            Constructor c = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            c.setAccessible(true);
            PluginCommand bukkitCommand = (PluginCommand)c.newInstance(new Object[]{this.name, Skript.getInstance()});
            bukkitCommand.setAliases(this.aliases);
            bukkitCommand.setDescription(this.description);
            bukkitCommand.setLabel(this.label);
            bukkitCommand.setPermission(this.permission);
            bukkitCommand.setPermissionMessage(this.permissionMessage);
            bukkitCommand.setUsage(this.usage);
            bukkitCommand.setExecutor((CommandExecutor)this);
            return bukkitCommand;
        }
        catch (Exception e) {
            Skript.outdatedError(e);
            throw new EmptyStackException();
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.setupBukkitCommand();
    }

    public boolean onCommand(@Nullable CommandSender sender, @Nullable Command command, @Nullable String label, @Nullable String[] args) {
        if (sender == null || label == null || args == null) {
            return false;
        }
        this.execute(sender, label, StringUtils.join(args, " "));
        return true;
    }

    public boolean execute(final CommandSender sender, String commandLabel, final String rest) {
        if (sender instanceof Player) {
            if ((this.executableBy & 1) == 0) {
                sender.sendMessage("" + m_executable_by_console);
                return false;
            }
        } else if ((this.executableBy & 2) == 0) {
            sender.sendMessage("" + m_executable_by_players);
            return false;
        }
        if (!this.permission.isEmpty() && !sender.hasPermission(this.permission)) {
            sender.sendMessage(this.permissionMessage);
            return false;
        }
        Boolean b = Task.callSync(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ScriptCommandEvent event = new ScriptCommandEvent(ScriptCommand.this, sender);
                ParseLogHandler log = SkriptLogger.startParseLogHandler();
                try {
                    boolean ok = SkriptParser.parseArguments(rest, ScriptCommand.this, event);
                    if (!ok) {
                        LogEntry e = log.getError();
                        if (e != null) {
                            sender.sendMessage(ChatColor.DARK_RED + e.getMessage());
                        }
                        sender.sendMessage(Commands.m_correct_usage + " " + ScriptCommand.this.usage);
                        log.clear();
                        log.printLog();
                        Boolean bl = false;
                        return bl;
                    }
                    log.clear();
                    log.printLog();
                }
                finally {
                    log.stop();
                }
                if (Skript.log(Verbosity.VERY_HIGH)) {
                    Skript.info("# /" + ScriptCommand.this.name + " " + rest);
                }
                long startTrigger = System.nanoTime();
                if (!ScriptCommand.this.trigger.execute(event)) {
                    sender.sendMessage(Commands.m_internal_error.toString());
                }
                if (Skript.log(Verbosity.VERY_HIGH)) {
                    Skript.info("# " + ScriptCommand.this.name + " took " + 1.0 * (double)(System.nanoTime() - startTrigger) / 1000000.0 + " milliseconds");
                }
                return true;
            }
        });
        return b != null ? b : false;
    }

    public void sendHelp(CommandSender sender) {
        if (!this.description.isEmpty()) {
            sender.sendMessage(this.description);
        }
        sender.sendMessage(ChatColor.GOLD + "Usage" + ChatColor.RESET + ": " + this.usage);
    }

    public List<Argument<?>> getArguments() {
        return this.arguments;
    }

    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SimpleCommandMap commandMap, Map<String, Command> knownCommands, @Nullable Set<String> aliases) {
        SimpleCommandMap simpleCommandMap = commandMap;
        synchronized (simpleCommandMap) {
            this.overriddenAliases.clear();
            this.overridden = knownCommands.put(this.label, (Command)this.bukkitCommand);
            if (aliases != null) {
                aliases.remove(this.label);
            }
            Iterator<String> as = this.activeAliases.iterator();
            while (as.hasNext()) {
                String lowerAlias = as.next().toLowerCase();
                if (knownCommands.containsKey(lowerAlias) && (aliases == null || !aliases.contains(lowerAlias))) {
                    as.remove();
                    continue;
                }
                this.overriddenAliases.put(lowerAlias, knownCommands.put(lowerAlias, (Command)this.bukkitCommand));
                if (aliases == null) continue;
                aliases.add(lowerAlias);
            }
            this.bukkitCommand.setAliases(this.activeAliases);
            this.bukkitCommand.register((CommandMap)commandMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(SimpleCommandMap commandMap, Map<String, Command> knownCommands, @Nullable Set<String> aliases) {
        SimpleCommandMap simpleCommandMap = commandMap;
        synchronized (simpleCommandMap) {
            knownCommands.remove(this.label);
            if (aliases != null) {
                aliases.removeAll(this.activeAliases);
            }
            for (String string : this.activeAliases) {
                knownCommands.remove(string);
            }
            this.activeAliases = new ArrayList<String>(this.aliases);
            this.bukkitCommand.unregister((CommandMap)commandMap);
            this.bukkitCommand.setAliases(this.aliases);
            if (this.overridden != null) {
                knownCommands.put(this.label, this.overridden);
                this.overridden = null;
            }
            for (Map.Entry entry : this.overriddenAliases.entrySet()) {
                if (entry.getValue() == null) continue;
                knownCommands.put((String)entry.getKey(), (Command)entry.getValue());
                if (aliases == null) continue;
                aliases.add((String)entry.getKey());
            }
            this.overriddenAliases.clear();
        }
    }

    public void registerHelp() {
        this.helps.clear();
        HelpMap help = Bukkit.getHelpMap();
        GenericCommandHelpTopic t = new GenericCommandHelpTopic((Command)this.bukkitCommand);
        help.addTopic((HelpTopic)t);
        this.helps.add((HelpTopic)t);
        HelpTopic aliases = help.getHelpTopic("Aliases");
        if (aliases != null && aliases instanceof IndexHelpTopic) {
            aliases.getFullText((CommandSender)Bukkit.getConsoleSender());
            try {
                Field topics = IndexHelpTopic.class.getDeclaredField("allTopics");
                topics.setAccessible(true);
                ArrayList<Commands.CommandAliasHelpTopic> as = new ArrayList<Commands.CommandAliasHelpTopic>((Collection)topics.get(aliases));
                for (String alias : this.activeAliases) {
                    Commands.CommandAliasHelpTopic at = new Commands.CommandAliasHelpTopic("/" + alias, "/" + this.getLabel(), help);
                    as.add(at);
                    this.helps.add(at);
                }
                Collections.sort(as, HelpTopicComparator.helpTopicComparatorInstance());
                topics.set(aliases, as);
            }
            catch (Exception e) {
                Skript.outdatedError(e);
            }
        }
    }

    public void unregisterHelp() {
        Bukkit.getHelpMap().getHelpTopics().removeAll(this.helps);
        HelpTopic aliases = Bukkit.getHelpMap().getHelpTopic("Aliases");
        if (aliases != null && aliases instanceof IndexHelpTopic) {
            try {
                Field topics = IndexHelpTopic.class.getDeclaredField("allTopics");
                topics.setAccessible(true);
                ArrayList as = new ArrayList((Collection)topics.get(aliases));
                as.removeAll(this.helps);
                topics.set(aliases, as);
            }
            catch (Exception e) {
                Skript.outdatedError(e);
            }
        }
        this.helps.clear();
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<String> getActiveAliases() {
        return this.activeAliases;
    }

    public PluginCommand getBukkitCommand() {
        return this.bukkitCommand;
    }

    @Nullable
    public File getScript() {
        return this.trigger.getScript();
    }
}

