/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.Utils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.WeakHashMap;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class Argument<T> {
    @Nullable
    private final Expression<? extends T> def;
    private final ClassInfo<T> type;
    private final boolean single;
    private final int index;
    private final boolean optional;
    private transient WeakHashMap<Event, T[]> current = new WeakHashMap();

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.current = new WeakHashMap();
    }

    public Argument(@Nullable Expression<? extends T> def, ClassInfo<T> type, boolean single, int index, boolean optional) {
        this.def = def;
        this.type = type;
        this.single = single;
        this.index = index;
        this.optional = optional;
    }

    @Nullable
    public static <T> Argument<T> newInstance(ClassInfo<T> type, @Nullable String def, int index, boolean single, boolean forceOptional) {
        Expression<Object> d = null;
        if (def != null) {
            if (def.startsWith("%") && def.endsWith("%")) {
                RetainingLogHandler log = SkriptLogger.startRetainingLog();
                try {
                    d = new SkriptParser(def.substring(1, def.length() - 1), 1, ParseContext.COMMAND).parseExpression(type.getC());
                    if (d == null) {
                        log.printErrors("Can't understand this expression: " + def);
                        return null;
                    }
                    log.printLog();
                }
                finally {
                    log.stop();
                }
            }
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                d = type.getC() == String.class ? (def.startsWith("\"") && def.endsWith("\"") ? VariableString.newInstance(def.substring(1, def.length() - 1)) : new SimpleLiteral<String>(def, false)) : SkriptParser.parseLiteral(def, type.getC(), ParseContext.DEFAULT);
                if (d == null) {
                    log.printErrors("'" + def + "' is not " + type.getName().withIndefiniteArticle());
                    return null;
                }
                log.printLog();
            }
            finally {
                log.stop();
            }
        }
        return new Argument<T>(d, type, single, index, def != null || forceOptional);
    }

    public String toString() {
        Expression<T> def = this.def;
        return "<" + Utils.toEnglishPlural(this.type.getCodeName(), !this.single) + (def == null ? "" : " = " + def.toString()) + ">";
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setToDefault(ScriptCommandEvent event) {
        if (this.def != null) {
            this.current.put(event, this.def.getArray(event));
        }
    }

    public void set(ScriptCommandEvent e, Object[] o) {
        if (!this.type.getC().isAssignableFrom(o.getClass().getComponentType())) {
            throw new IllegalArgumentException();
        }
        this.current.put(e, o);
    }

    @Nullable
    public T[] getCurrent(Event e) {
        return this.current.get(e);
    }

    public Class<T> getType() {
        return this.type.getC();
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSingle() {
        return this.single;
    }
}

