/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.util.Experience;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;

public class DefaultChangers {
    public static final Changer<Entity> entityChanger = new Changer<Entity>(){

        @Override
        @Nullable
        public Class<? extends Object>[] acceptChange(Changer.ChangeMode mode) {
            switch (mode) {
                case ADD: {
                    return CollectionUtils.array(ItemType[].class, Inventory.class, Experience[].class);
                }
                case DELETE: {
                    return CollectionUtils.array(new Class[0]);
                }
                case REMOVE: {
                    return CollectionUtils.array(PotionEffectType[].class, ItemType[].class, Inventory.class);
                }
                case REMOVE_ALL: {
                    return CollectionUtils.array(PotionEffectType[].class, ItemType[].class);
                }
                case SET: 
                case RESET: {
                    return null;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        public void change(Entity[] entities, @Nullable Object[] delta, Changer.ChangeMode mode) {
            if (delta == null) {
                Entity[] entityArray = entities;
                int n = entities.length;
                int n2 = 0;
                while (n2 < n) {
                    Entity e = entityArray[n2];
                    if (!(e instanceof Player)) {
                        e.remove();
                    }
                    ++n2;
                }
                return;
            }
            Entity[] entityArray = entities;
            int n = entities.length;
            int n3 = 0;
            while (n3 < n) {
                Entity e = entityArray[n3];
                Object[] objectArray = delta;
                int n4 = delta.length;
                int n5 = 0;
                while (n5 < n4) {
                    Object d = objectArray[n5];
                    if (d instanceof PotionEffectType) {
                        if (!$assertionsDisabled && mode != Changer.ChangeMode.REMOVE && mode != Changer.ChangeMode.REMOVE_ALL) {
                            throw new AssertionError();
                        }
                        if (e instanceof LivingEntity) {
                            ((LivingEntity)e).removePotionEffect((PotionEffectType)d);
                        }
                    } else if (e instanceof Player) {
                        PlayerInventory invi;
                        Player p = (Player)e;
                        if (d instanceof Experience) {
                            p.giveExp(((Experience)d).getXP());
                        } else if (d instanceof Inventory) {
                            invi = p.getInventory();
                            if (mode == Changer.ChangeMode.ADD) {
                                for (ItemStack i : (Inventory)d) {
                                    if (i == null) continue;
                                    invi.addItem(new ItemStack[]{i});
                                }
                            } else {
                                invi.removeItem(((Inventory)d).getContents());
                            }
                        } else if (d instanceof ItemType && (invi = p.getInventory()) != null) {
                            if (mode == Changer.ChangeMode.ADD) {
                                ((ItemType)d).addTo((Inventory)invi);
                            } else if (mode == Changer.ChangeMode.REMOVE) {
                                ((ItemType)d).removeFrom((Inventory)invi);
                            } else {
                                ((ItemType)d).removeAll((Inventory)invi);
                            }
                        }
                    }
                    ++n5;
                }
                if (e instanceof Player) {
                    PlayerUtils.updateInventory((Player)e);
                }
                ++n3;
            }
        }
    };
    public static final Changer<Player> playerChanger = new Changer<Player>(){

        @Override
        @Nullable
        public Class<? extends Object>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.DELETE) {
                return null;
            }
            return entityChanger.acceptChange(mode);
        }

        public void change(Player[] players, Object[] delta, Changer.ChangeMode mode) {
            entityChanger.change((Entity[])players, delta, mode);
        }
    };
    public static final Changer<Entity> nonLivingEntityChanger = new Changer<Entity>(){

        @Override
        @Nullable
        public Class<Object>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.DELETE) {
                return CollectionUtils.array(new Class[0]);
            }
            return null;
        }

        public void change(Entity[] entities, @Nullable Object[] delta, Changer.ChangeMode mode) {
            if (!$assertionsDisabled && mode != Changer.ChangeMode.DELETE) {
                throw new AssertionError();
            }
            Entity[] entityArray = entities;
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                Entity e = entityArray[n2];
                if (!(e instanceof Player)) {
                    e.remove();
                }
                ++n2;
            }
        }
    };
    public static final Changer<Item> itemChanger = new Changer<Item>(){

        @Override
        @Nullable
        public Class<?>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.SET) {
                return CollectionUtils.array(ItemStack.class);
            }
            return nonLivingEntityChanger.acceptChange(mode);
        }

        public void change(Item[] what, @Nullable Object[] delta, Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.SET) {
                if (!$assertionsDisabled && delta == null) {
                    throw new AssertionError();
                }
                Item[] itemArray = what;
                int n = what.length;
                int n2 = 0;
                while (n2 < n) {
                    Item i = itemArray[n2];
                    i.setItemStack((ItemStack)delta[0]);
                    ++n2;
                }
            } else {
                nonLivingEntityChanger.change((Entity[])what, delta, mode);
            }
        }
    };
    public static final Changer<Inventory> inventoryChanger = new Changer<Inventory>(){

        @Override
        @Nullable
        public Class<? extends Object>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.RESET) {
                return null;
            }
            if (mode == Changer.ChangeMode.REMOVE_ALL) {
                return CollectionUtils.array(ItemType[].class);
            }
            if (mode == Changer.ChangeMode.SET) {
                return CollectionUtils.array(ItemType[].class, Inventory.class);
            }
            return CollectionUtils.array(ItemType[].class, Inventory[].class);
        }

        public void change(Inventory[] invis, @Nullable Object[] delta, Changer.ChangeMode mode) {
            Inventory[] inventoryArray = invis;
            int n = invis.length;
            int n2 = 0;
            while (n2 < n) {
                Inventory invi = inventoryArray[n2];
                if (!$assertionsDisabled && invi == null) {
                    throw new AssertionError();
                }
                switch (mode) {
                    case DELETE: {
                        invi.clear();
                        if (!(invi instanceof PlayerInventory)) break;
                        ((PlayerInventory)invi).setArmorContents(new ItemStack[4]);
                        if (!(((PlayerInventory)invi).getHolder() instanceof Player)) break;
                        Player p = (Player)((PlayerInventory)invi).getHolder();
                        if (invi.equals(p.getOpenInventory().getBottomInventory())) {
                            p.getOpenInventory().setCursor(null);
                        }
                        if (!(p.getOpenInventory().getTopInventory() instanceof CraftingInventory)) break;
                        p.getOpenInventory().getTopInventory().clear();
                        break;
                    }
                    case SET: {
                        invi.clear();
                    }
                    case ADD: {
                        Object d;
                        if (!$assertionsDisabled && delta == null) {
                            throw new AssertionError();
                        }
                        Object[] objectArray = delta;
                        int n3 = delta.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            d = objectArray[n4];
                            if (d instanceof Inventory) {
                                for (ItemStack i : (Inventory)d) {
                                    if (i == null) continue;
                                    invi.addItem(new ItemStack[]{i});
                                }
                            } else {
                                ((ItemType)d).addTo(invi);
                            }
                            ++n4;
                        }
                        break;
                    }
                    case REMOVE: 
                    case REMOVE_ALL: {
                        Object d;
                        if (!$assertionsDisabled && delta == null) {
                            throw new AssertionError();
                        }
                        Object[] objectArray = delta;
                        int n3 = delta.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            d = objectArray[n4];
                            if (d instanceof Inventory) {
                                if (!$assertionsDisabled && mode != Changer.ChangeMode.REMOVE) {
                                    throw new AssertionError();
                                }
                                invi.removeItem(((Inventory)d).getContents());
                            } else if (mode == Changer.ChangeMode.REMOVE) {
                                ((ItemType)d).removeFrom(invi);
                            } else {
                                ((ItemType)d).removeAll(invi);
                            }
                            ++n4;
                        }
                        break;
                    }
                    case RESET: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                if (invi.getHolder() instanceof Player) {
                    ((Player)invi.getHolder()).updateInventory();
                }
                ++n2;
            }
        }
    };
    public static final Changer<Block> blockChanger = new Changer<Block>(){

        @Override
        @Nullable
        public Class<?>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.RESET) {
                return null;
            }
            if (mode == Changer.ChangeMode.SET) {
                return CollectionUtils.array(ItemType.class);
            }
            return CollectionUtils.array(ItemType[].class, Inventory[].class);
        }

        public void change(Block[] blocks, @Nullable Object[] delta, Changer.ChangeMode mode) {
            Block[] blockArray = blocks;
            int n = blocks.length;
            int n2 = 0;
            while (n2 < n) {
                Block block = blockArray[n2];
                if (!$assertionsDisabled && block == null) {
                    throw new AssertionError();
                }
                switch (mode) {
                    case SET: {
                        if (!$assertionsDisabled && delta == null) {
                            throw new AssertionError();
                        }
                        ((ItemType)delta[0]).getBlock().setBlock(block, true);
                        break;
                    }
                    case DELETE: {
                        block.setTypeId(0, true);
                        break;
                    }
                    case ADD: 
                    case REMOVE: 
                    case REMOVE_ALL: {
                        Object d;
                        int n3;
                        int n4;
                        Object[] objectArray;
                        Inventory invi;
                        if (!$assertionsDisabled && delta == null) {
                            throw new AssertionError();
                        }
                        BlockState state = block.getState();
                        if (!(state instanceof InventoryHolder) || (invi = ((InventoryHolder)state).getInventory()) == null) break;
                        if (mode == Changer.ChangeMode.ADD) {
                            objectArray = delta;
                            n4 = delta.length;
                            n3 = 0;
                            while (n3 < n4) {
                                d = objectArray[n3];
                                if (d instanceof Inventory) {
                                    for (ItemStack i : (Inventory)d) {
                                        if (i == null) continue;
                                        invi.addItem(new ItemStack[]{i});
                                    }
                                } else {
                                    ((ItemType)d).addTo(invi);
                                }
                                ++n3;
                            }
                        } else {
                            objectArray = delta;
                            n4 = delta.length;
                            n3 = 0;
                            while (n3 < n4) {
                                d = objectArray[n3];
                                if (d instanceof Inventory) {
                                    invi.removeItem(((Inventory)d).getContents());
                                } else if (mode == Changer.ChangeMode.REMOVE) {
                                    ((ItemType)d).removeFrom(invi);
                                } else {
                                    ((ItemType)d).removeAll(invi);
                                }
                                ++n3;
                            }
                        }
                        state.update();
                        break;
                    }
                    case RESET: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
                ++n2;
            }
        }
    };
}

