/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.localization.FormattedMessage;
import ch.njol.skript.localization.Message;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.Version;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang.StringEscapeUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public final class Updater {
    private static final String filesURL = "https://api.curseforge.com/servermods/files?projectIds=32084";
    private static final String RSSURL = "http://dev.bukkit.org/server-mods/skript/files.rss";
    private static final DateFormat RFC2822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    public static final ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock();
    public static volatile UpdateState state = UpdateState.NOT_STARTED;
    static final AtomicReference<String> error = new AtomicReference();
    public static final List<VersionInfo> infos = new ArrayList<VersionInfo>();
    public static final AtomicReference<VersionInfo> latest = new AtomicReference();
    public static final Message m_not_started = new Message("updater.not started");
    public static final Message m_checking = new Message("updater.checking");
    public static final Message m_check_in_progress = new Message("updater.check in progress");
    public static final FormattedMessage m_check_error = new FormattedMessage("updater.check error", error);
    public static final Message m_running_latest_version = new Message("updater.running latest version");
    public static final Message m_running_latest_version_beta = new Message("updater.running latest version (beta)");
    public static final FormattedMessage m_update_available = new FormattedMessage("updater.update available", latest, Skript.getVersion());
    public static final FormattedMessage m_downloading = new FormattedMessage("updater.downloading", latest);
    public static final Message m_download_in_progress = new Message("updater.download in progress");
    public static final FormattedMessage m_download_error = new FormattedMessage("updater.download error", error);
    public static final FormattedMessage m_downloaded = new FormattedMessage("updater.downloaded", latest);
    public static final Message m_internal_error = new Message("updater.internal error");
    @Nullable
    static Task checkerTask = null;

    static void start() {
        checkerTask = new Task((Plugin)Skript.getInstance(), 0L, true){

            @Override
            public void run() {
                if (!SkriptConfig.checkForNewVersion.value().booleanValue()) {
                    return;
                }
                Updater.check((CommandSender)Bukkit.getConsoleSender(), SkriptConfig.automaticallyDownloadNewVersion.value(), true);
                Timespan t = SkriptConfig.updateCheckInterval.value();
                if (t.getTicks() != 0) {
                    this.setNextExecution(t.getTicks());
                }
            }
        };
    }

    static void check(final CommandSender sender, final boolean download, final boolean isAutomatic) {
        stateLock.writeLock().lock();
        try {
            if (state == UpdateState.CHECK_IN_PROGRESS || state == UpdateState.DOWNLOAD_IN_PROGRESS) {
                return;
            }
            state = UpdateState.CHECK_IN_PROGRESS;
        }
        finally {
            stateLock.writeLock().unlock();
        }
        if (!isAutomatic || Skript.logNormal()) {
            Skript.info(sender, "" + m_checking);
        }
        Skript.newThread(new Runnable(){

            @Override
            public void run() {
                block43: {
                    infos.clear();
                    InputStream in = null;
                    try {
                        try {
                            String message;
                            URLConnection conn = new URL(Updater.filesURL).openConnection();
                            conn.setRequestProperty("User-Agent", "Skript/v" + Skript.getVersion() + " (by Njol)");
                            in = conn.getInputStream();
                            BufferedReader reader = new BufferedReader(new InputStreamReader(in, conn.getContentEncoding() == null ? "UTF-8" : conn.getContentEncoding()));
                            try {
                                String line = reader.readLine();
                                if (line != null) {
                                    JSONArray a = (JSONArray)JSONValue.parse((String)line);
                                    for (Object o : a) {
                                        Version version;
                                        Object url;
                                        Object name = ((JSONObject)o).get((Object)"name");
                                        if (!(name instanceof String) || !((String)name).matches("\\d+\\.\\d+(\\.\\d+)?( \\(jar( only)?\\))?") || !((url = ((JSONObject)o).get((Object)"downloadUrl")) instanceof String) || (version = new Version(((String)name).contains(" ") ? ((String)name).substring(0, ((String)name).indexOf(32)) : (String)name)).compareTo(Skript.getVersion()) <= 0) continue;
                                        infos.add(new VersionInfo((String)name, version, (String)url));
                                    }
                                }
                            }
                            finally {
                                reader.close();
                            }
                            if (!infos.isEmpty()) {
                                Collections.sort(infos);
                                latest.set(infos.get(0));
                            } else {
                                latest.set(null);
                            }
                            Updater.getChangelogs(sender);
                            String string = infos.isEmpty() ? (Skript.getVersion().isStable() ? "" + m_running_latest_version : "" + m_running_latest_version_beta) : (message = "" + m_update_available);
                            if (isAutomatic && !infos.isEmpty()) {
                                Skript.adminBroadcast(message);
                            } else {
                                Skript.info(sender, message);
                            }
                            if (download && !infos.isEmpty()) {
                                stateLock.writeLock().lock();
                                try {
                                    state = UpdateState.DOWNLOAD_IN_PROGRESS;
                                }
                                finally {
                                    stateLock.writeLock().unlock();
                                }
                                Updater.download_i(sender, isAutomatic);
                                break block43;
                            }
                            stateLock.writeLock().lock();
                            try {
                                state = UpdateState.CHECKED_FOR_UPDATE;
                            }
                            finally {
                                stateLock.writeLock().unlock();
                            }
                        }
                        catch (IOException e) {
                            stateLock.writeLock().lock();
                            try {
                                state = UpdateState.CHECK_ERROR;
                                error.set(ExceptionUtils.toString(e));
                                if (sender != null) {
                                    Skript.error(sender, m_check_error.toString());
                                }
                            }
                            finally {
                                stateLock.writeLock().unlock();
                            }
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        catch (Exception e) {
                            if (sender != null) {
                                Skript.error(sender, m_internal_error.toString());
                            }
                            Skript.exception((Throwable)e, "Unexpected error while checking for a new version of Skript");
                            stateLock.writeLock().lock();
                            try {
                                state = UpdateState.CHECK_ERROR;
                                error.set(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getLocalizedMessage());
                            }
                            finally {
                                stateLock.writeLock().unlock();
                            }
                        }
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }, "Skript update thread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void getChangelogs(CommandSender sender) {
        InputStream in = null;
        InputStreamReader r = null;
        try {
            try {
                URLConnection conn = new URL(RSSURL).openConnection();
                conn.setRequestProperty("User-Agent", "Skript/v" + Skript.getVersion() + " (by Njol)");
                in = conn.getInputStream();
                r = new InputStreamReader(in, conn.getContentEncoding() == null ? "UTF-8" : conn.getContentEncoding());
                XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(r);
                infos.clear();
                VersionInfo current = null;
                block32: while (reader.hasNext()) {
                    XMLEvent e = reader.nextEvent();
                    if (!e.isStartElement()) continue;
                    String element = e.asStartElement().getName().getLocalPart();
                    if (element.equalsIgnoreCase("title")) {
                        String name = reader.nextEvent().asCharacters().getData().trim();
                        for (VersionInfo i : infos) {
                            if (!name.equals(i.name)) continue;
                            current = i;
                            continue block32;
                        }
                        current = null;
                        continue;
                    }
                    if (element.equalsIgnoreCase("description")) {
                        if (current == null) continue;
                        StringBuilder cl = new StringBuilder();
                        while ((e = reader.nextEvent()).isCharacters()) {
                            cl.append(e.asCharacters().getData());
                        }
                        current.changelog = "- " + StringEscapeUtils.unescapeHtml((String)("" + cl)).replace("<br>", "").replace("<p>", "").replace("</p>", "").replaceAll("\n(?!\n)", "\n- ");
                        continue;
                    }
                    if (!element.equalsIgnoreCase("pubDate") || current == null) continue;
                    DateFormat dateFormat = RFC2822;
                    synchronized (dateFormat) {
                        current.date = new Date(RFC2822.parse(reader.nextEvent().asCharacters().getData()).getTime());
                    }
                }
            }
            catch (IOException e) {
                stateLock.writeLock().lock();
                try {
                    state = UpdateState.CHECK_ERROR;
                    error.set(ExceptionUtils.toString(e));
                    Skript.error(sender, m_check_error.toString());
                }
                finally {
                    stateLock.writeLock().unlock();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                Skript.error(sender, m_internal_error.toString());
                Skript.exception((Throwable)e, "Unexpected error while checking for a new version of Skript");
                stateLock.writeLock().lock();
                try {
                    state = UpdateState.CHECK_ERROR;
                    error.set(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getLocalizedMessage());
                }
                finally {
                    stateLock.writeLock().unlock();
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static void download_i(CommandSender sender, boolean isAutomatic) {
        assert (sender != null);
        stateLock.readLock().lock();
        try {
            if (state != UpdateState.DOWNLOAD_IN_PROGRESS) {
                throw new IllegalStateException();
            }
        }
        finally {
            stateLock.readLock().unlock();
        }
        Skript.info(sender, "" + m_downloading);
        InputStream in = null;
        try {
            try {
                URLConnection conn = new URL(Updater.latest.get().downloadURL).openConnection();
                in = conn.getInputStream();
                assert (in != null);
                FileUtils.save(in, new File(Bukkit.getUpdateFolderFile(), "Skript.jar"));
                if (isAutomatic) {
                    Skript.adminBroadcast("" + m_downloaded);
                } else {
                    Skript.info(sender, "" + m_downloaded);
                }
                stateLock.writeLock().lock();
                try {
                    state = UpdateState.DOWNLOADED;
                }
                finally {
                    stateLock.writeLock().unlock();
                }
            }
            catch (IOException e) {
                stateLock.writeLock().lock();
                try {
                    state = UpdateState.DOWNLOAD_ERROR;
                    error.set(ExceptionUtils.toString(e));
                    Skript.error(sender, m_download_error.toString());
                }
                finally {
                    stateLock.writeLock().unlock();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, "Error while downloading the latest version of Skript");
                stateLock.writeLock().lock();
                try {
                    state = UpdateState.DOWNLOAD_ERROR;
                    error.set(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getLocalizedMessage());
                }
                finally {
                    stateLock.writeLock().unlock();
                }
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void download(final CommandSender sender, final boolean isAutomatic) {
        assert (sender != null);
        stateLock.writeLock().lock();
        try {
            if (state != UpdateState.CHECKED_FOR_UPDATE && state != UpdateState.DOWNLOAD_ERROR) {
                throw new IllegalStateException("Must check for an update first");
            }
            state = UpdateState.DOWNLOAD_IN_PROGRESS;
        }
        finally {
            stateLock.writeLock().unlock();
        }
        Skript.newThread(new Runnable(){

            @Override
            public void run() {
                Updater.download_i(sender, isAutomatic);
            }
        }, "Skript download thread").start();
    }

    public static enum UpdateState {
        NOT_STARTED,
        CHECK_IN_PROGRESS,
        CHECK_ERROR,
        CHECKED_FOR_UPDATE,
        DOWNLOAD_IN_PROGRESS,
        DOWNLOAD_ERROR,
        DOWNLOADED;

    }

    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public static final class VersionInfo
    implements Comparable<VersionInfo> {
        final String name;
        final Version version;
        final String downloadURL;
        @Nullable
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="used in SkriptCommand")
        String changelog;
        @Nullable
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="used in SkriptCommand")
        Date date;

        VersionInfo(String name, Version version, String downloadURL) {
            this.name = name;
            this.version = version;
            this.downloadURL = downloadURL;
        }

        public String toString() {
            return this.version.toString();
        }

        @Override
        public int compareTo(VersionInfo o) {
            return this.version.compareTo(o.version);
        }
    }
}

