/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util;

import ch.njol.util.Callback;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtils {
    public static String fancyOrderNumber(int i) {
        int imod10 = i % 10;
        if (imod10 == 1) {
            return String.valueOf(i) + "st";
        }
        if (imod10 == 2) {
            return String.valueOf(i) + "nd";
        }
        if (imod10 == 3) {
            return String.valueOf(i) + "rd";
        }
        return String.valueOf(i) + "th";
    }

    public static final String replaceAll(String string, String regex, Callback<String, Matcher> callback) {
        return StringUtils.replaceAll(string, Pattern.compile(regex), callback);
    }

    public static final String replaceAll(String string, Pattern regex, Callback<String, Matcher> callback) {
        Matcher m = regex.matcher(string);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String r = callback.run(m);
            if (r == null) {
                return null;
            }
            m.appendReplacement(sb, r);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static int count(String s, char c) {
        int r = 0;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char x = cArray[n2];
            if (x == c) {
                ++r;
            }
            ++n2;
        }
        return r;
    }

    public static int count(String s, char c, int start) {
        return StringUtils.count(s, c, start, s.length());
    }

    public static int count(String s, char c, int start, int end) {
        if (start < 0 || end > s.length()) {
            throw new StringIndexOutOfBoundsException("invalid start/end indices " + start + "," + end + " for string \"" + s + "\" (length " + s.length() + ")");
        }
        int r = 0;
        int i = start;
        while (i < end) {
            if (s.charAt(i) == c) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    public static final String toString(double d, int accuracy) {
        String s = String.format(Locale.ENGLISH, "%." + accuracy + "f", d);
        int c = s.length() - 1;
        while (s.charAt(c) == '0') {
            --c;
        }
        if (s.charAt(c) == '.') {
            --c;
        }
        return s.substring(0, c + 1);
    }

    public static final String firstToUpper(String s) {
        if (s.isEmpty()) {
            return s;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
    }

    public static final String substring(String s, int start, int end) {
        if (start < 0) {
            start += s.length();
        }
        if (end < 0) {
            end += s.length();
        }
        if (end < start) {
            throw new IllegalArgumentException("invalid indices");
        }
        return s.substring(start, end);
    }

    /*
     * Unable to fully structure code
     */
    public static String fixCapitalization(String string) {
        s = string.toCharArray();
        c = 0;
        ** GOTO lbl12
        {
            ++c;
            do {
                if (c < s.length && (s[c] == '.' || s[c] == '!' || s[c] == '?' || Character.isWhitespace(s[c]))) continue block0;
                if (c == s.length) {
                    return new String(s);
                }
                if (c == 0 || s[c - 1] != '.') {
                    s[c] = Character.toUpperCase(s[c]);
                }
                c = StringUtils.indexOf(s, c + 1, new char[]{'.', '!', '?'});
lbl12:
                // 2 sources

            } while (c != -1);
        }
        return new String(s);
    }

    private static final int indexOf(char[] s, int start, char ... cs) {
        int i = start;
        while (i < s.length) {
            char[] cArray = cs;
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (s[i] == c) {
                    return i;
                }
                ++n2;
            }
            ++i;
        }
        return -1;
    }

    public static final double numberBefore(CharSequence s, int index) {
        boolean stillWhitespace = true;
        boolean hasDot = false;
        int start = -1;
        int end = -1;
        int i = index;
        while (i >= 0) {
            if ('0' < s.charAt(i) && s.charAt(i) < '9') {
                start = start == -1 ? (end = i) : --start;
                stillWhitespace = false;
            } else if (s.charAt(i) == '.') {
                if (hasDot) break;
                start = start == -1 ? (end = i) : --start;
                hasDot = true;
                stillWhitespace = false;
            } else if (!Character.isWhitespace(s.charAt(i)) || !stillWhitespace) break;
            --i;
        }
        if (start == -1) {
            return -1.0;
        }
        if (s.charAt(start) == '.') {
            return -1.0;
        }
        if (start != 0 && !Character.isWhitespace(s.charAt(start - 1))) {
            return -1.0;
        }
        return Double.parseDouble(s.subSequence(start, end + 1).toString());
    }

    public static boolean startsWithIgnoreCase(String string, String start) {
        return StringUtils.startsWithIgnoreCase(string, start, 0);
    }

    public static boolean startsWithIgnoreCase(String string, String start, int offset) {
        assert (string != null);
        assert (start != null);
        if (string.length() < offset + start.length()) {
            return false;
        }
        return string.substring(offset, start.length()).equalsIgnoreCase(start);
    }

    public static boolean endsWithIgnoreCase(String string, String end) {
        assert (string != null);
        assert (end != null);
        if (string.length() < end.length()) {
            return false;
        }
        return string.substring(string.length() - end.length()).equalsIgnoreCase(end);
    }

    public static final String multiply(String s, int amount) {
        assert (s != null);
        char[] input = s.toCharArray();
        char[] multiplied = new char[s.length() * amount];
        int i = 0;
        while (i < amount) {
            System.arraycopy(input, 0, multiplied, i * input.length, input.length);
            ++i;
        }
        return new String(multiplied);
    }

    public static final String multiply(char c, int amount) {
        char[] multiplied = new char[amount];
        int i = 0;
        while (i < amount) {
            multiplied[i] = c;
            ++i;
        }
        return new String(multiplied);
    }

    public static String join(Object[] strings) {
        return StringUtils.join(strings, ", ");
    }

    public static String join(Object[] strings, String delimiter) {
        return StringUtils.join(strings, delimiter, 0, strings.length);
    }

    public static String join(Object[] strings, String delimiter, int start, int end) {
        assert (strings != null);
        if (strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return "" + strings[0];
        }
        StringBuilder b = new StringBuilder();
        int i = start;
        while (i < end) {
            if (i != start) {
                b.append(delimiter);
            }
            b.append(strings[i]);
            ++i;
        }
        return b.toString();
    }

    public static String join(Iterable<?> strings) {
        return StringUtils.join(strings.iterator(), ", ");
    }

    public static String join(Iterable<?> strings, String delimiter) {
        return StringUtils.join(strings.iterator(), delimiter);
    }

    public static String join(Iterator<?> strings, String delimiter) {
        assert (strings != null);
        if (!strings.hasNext()) {
            return "";
        }
        StringBuilder b = new StringBuilder("" + strings.next());
        while (strings.hasNext()) {
            b.append(delimiter);
            b.append(strings.next());
        }
        return b.toString();
    }

    public static final int findLastDigit(String s, int start) {
        int end = start;
        while (end < s.length() && '0' <= s.charAt(end) && s.charAt(end) <= '9') {
            ++end;
        }
        return end;
    }

    public static boolean containsAny(String s, String chars) {
        int i = 0;
        while (i < chars.length()) {
            if (s.indexOf(chars.charAt(i)) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

