/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.Version;
import ch.njol.skript.variables.DatabaseStorage;
import ch.njol.skript.variables.Variables;
import ch.njol.skript.variables.VariablesStorage;
import ch.njol.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlatFileStorage
extends VariablesStorage {
    private File file;
    private volatile PrintWriter changesWriter;
    private volatile int changes = 0;
    private final int REQUIRED_CHANGES_FOR_RESAVE = 50;
    private Task saveTask;
    public Task backupTask = null;
    private boolean loadError = false;
    private static final Pattern csv = Pattern.compile("\\s*([^\",]+|\"([^\"]|\"\")*\")\\s*(,|$)");

    public void startBackupTask(Timespan t) {
        this.backupTask = new Task(Skript.getInstance(), t.getTicks(), t.getTicks(), true){

            @Override
            public void run() {
                try {
                    Variables.getReadLock().lock();
                    FlatFileStorage.this.closeChangesWriter();
                    try {
                        try {
                            FileUtils.backup(FlatFileStorage.this.file);
                        }
                        catch (IOException e) {
                            Skript.error("Automatic variables backup failed: " + e.getLocalizedMessage());
                            FlatFileStorage.this.setupChangesWriter();
                        }
                    }
                    finally {
                        FlatFileStorage.this.setupChangesWriter();
                    }
                }
                finally {
                    Variables.getReadLock().unlock();
                }
            }
        };
    }

    @Override
    protected boolean load_i() {
        RetainingLogHandler log;
        StringBuilder invalid;
        int unsuccessful;
        boolean ioEx;
        block40: {
            this.file = new File(Skript.getInstance().getDataFolder(), "variables.csv");
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                Skript.error("Cannot create the variables file: " + e.getLocalizedMessage());
                return false;
            }
            if (!this.file.canWrite()) {
                Skript.error("Cannot write to the variables file - no variables will be saved!");
            }
            if (!this.file.canRead()) {
                Skript.error("Cannot read from the variables file!");
                Skript.error("This means that no variables will be available and can also prevent new variables from being saved!");
                try {
                    File backup = FileUtils.backup(this.file);
                    Skript.error("A backup of your variables.csv was created as " + backup.getName());
                }
                catch (IOException e) {
                    Skript.error("Failed to create a backup of your variables.csv: " + e.getLocalizedMessage());
                    this.loadError = true;
                }
                return false;
            }
            ioEx = false;
            unsuccessful = 0;
            invalid = new StringBuilder();
            log = SkriptLogger.startRetainingLog();
            try {
                Version varVersion = Skript.getVersion();
                Version v2_0_beta3 = new Version(2, 0, "beta 3");
                BufferedReader r = null;
                try {
                    try {
                        r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
                        String line = null;
                        int lineNum = 0;
                        while ((line = r.readLine()) != null) {
                            ++lineNum;
                            if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
                                if (!line.startsWith("# version:")) continue;
                                try {
                                    varVersion = new Version(line.substring("# version:".length()).trim());
                                }
                                catch (IllegalArgumentException illegalArgumentException) {}
                                continue;
                            }
                            String[] split = FlatFileStorage.splitCSV(line);
                            if (split == null || split.length != 3) {
                                Skript.error("invalid amount of commas in line " + lineNum + " ('" + line + "')");
                                if (invalid.length() != 0) {
                                    invalid.append(", ");
                                }
                                invalid.append(split == null ? "<unknown>" : split[0]);
                                ++unsuccessful;
                                continue;
                            }
                            if (split[1].equals("null")) {
                                Variables.setVariable(split[0], null, this);
                                continue;
                            }
                            Object d = Classes.deserialize(split[1], split[2]);
                            if (d == null) {
                                if (invalid.length() != 0) {
                                    invalid.append(", ");
                                }
                                invalid.append(split[0]);
                                ++unsuccessful;
                                continue;
                            }
                            if (d instanceof String && varVersion.isSmallerThan(v2_0_beta3)) {
                                d = Utils.replaceChatStyles((String)d);
                            }
                            Variables.setVariable(split[0], d, this);
                        }
                    }
                    catch (IOException e) {
                        Skript.error(e.getLocalizedMessage());
                        this.loadError = true;
                        ioEx = true;
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block40;
                    }
                }
                catch (Throwable throwable) {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                log.stop();
            }
        }
        if (ioEx || unsuccessful > 0) {
            if (unsuccessful > 0) {
                Skript.error(String.valueOf(unsuccessful) + " variable" + (unsuccessful == 1 ? "" : "s") + " could not be loaded!");
                Skript.error("Affected variables: " + invalid.toString());
                if (log.hasErrors()) {
                    Skript.error("further information:");
                    log.printErrors(null);
                }
            }
            if (ioEx) {
                Skript.error("An I/O error occurred while loading the variables");
                Skript.error("This means that some to all variables could not be loaded!");
            }
            try {
                File backup = FileUtils.backup(this.file);
                Skript.info("Created a backup of variables.csv as " + backup.getName());
                this.loadError = false;
            }
            catch (IOException ex) {
                Skript.error("Could not backup variables.csv: " + ex.getMessage());
            }
        }
        this.setupChangesWriter();
        this.saveTask = new Task(Skript.getInstance(), 6000L, 6000L, true){

            @Override
            public void run() {
                if (FlatFileStorage.this.changes >= 50) {
                    try {
                        Variables.getReadLock().lock();
                        FlatFileStorage.this.saveVariables(false);
                        FlatFileStorage.this.changes = 0;
                    }
                    finally {
                        Variables.getReadLock().unlock();
                    }
                }
            }
        };
        if (this.backupTask == null && SkriptConfig.variableBackupInterval.value() != null) {
            this.startBackupTask(SkriptConfig.variableBackupInterval.value());
        }
        return !ioEx;
    }

    private static final String[] splitCSV(String line) {
        Matcher m = csv.matcher(line);
        int lastEnd = 0;
        ArrayList<String> r = new ArrayList<String>();
        while (m.find()) {
            if (lastEnd != m.start()) {
                return null;
            }
            if (m.group(1).startsWith("\"")) {
                r.add(m.group(1).substring(1, m.group(1).length() - 1).replace("\"\"", "\""));
            } else {
                r.add(m.group(1));
            }
            lastEnd = m.end();
        }
        if (lastEnd != line.length()) {
            return null;
        }
        return r.toArray(new String[r.size()]);
    }

    @Override
    protected void save(String name, String type, String value) {
        FlatFileStorage.writeCSV(this.changesWriter, name, type, value);
        this.changesWriter.flush();
        int c = this.changes;
        this.changes = c + 1;
    }

    private static final void writeCSV(PrintWriter pw, String ... values) {
        int i = 0;
        while (i < values.length) {
            String v;
            if (i != 0) {
                pw.print(", ");
            }
            if ((v = values[i]).contains(",") || v.contains("\"")) {
                v = String.valueOf('\"') + v.replace("\"", "\"\"") + '\"';
            }
            pw.print(v);
            ++i;
        }
        pw.println();
    }

    final void closeChangesWriter() {
        this.clearChangesQueue();
        if (this.changesWriter != null) {
            this.changesWriter.close();
            this.changesWriter = null;
        }
    }

    final void setupChangesWriter() {
        try {
            this.changesWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), "UTF-8"));
        }
        catch (FileNotFoundException e) {
            Skript.exception((Throwable)e, new String[0]);
        }
        catch (UnsupportedEncodingException e) {
            Skript.exception((Throwable)e, new String[0]);
        }
    }

    @Override
    public void close() {
        this.clearChangesQueue();
        super.close();
        this.saveVariables(true);
    }

    public final void saveVariables(boolean finalSave) {
        if (finalSave) {
            this.saveTask.cancel();
            if (this.backupTask != null) {
                this.backupTask.cancel();
            }
        }
        try {
            Variables.getReadLock().lock();
            this.closeChangesWriter();
            if (this.loadError) {
                try {
                    File backup = FileUtils.backup(this.file);
                    Skript.info("Created a backup of your old variables.csv as " + backup.getName());
                    this.loadError = false;
                }
                catch (IOException e) {
                    Skript.error("Could not backup the old variables.csv: " + e.getLocalizedMessage());
                    Skript.error("No variables are saved!");
                    Variables.getReadLock().unlock();
                    if (!finalSave) {
                        this.setupChangesWriter();
                    }
                    return;
                }
            }
            File tempFile = new File(Skript.getInstance().getDataFolder(), "variables.csv.temp");
            PrintWriter pw = null;
            try {
                try {
                    pw = new PrintWriter(tempFile, "UTF-8");
                    pw.println("# === Skript's variable storage ===");
                    pw.println("# Please do not modify this file manually!");
                    pw.println("#");
                    pw.println("# version: " + Skript.getInstance().getDescription().getVersion());
                    pw.println();
                    this.save(pw, "", Variables.getVariables());
                    pw.println();
                    pw.flush();
                    pw.close();
                    FileUtils.move(tempFile, this.file, true);
                }
                catch (IOException e) {
                    Skript.error("Unable to save variables: " + e.getLocalizedMessage());
                    if (pw != null) {
                        pw.close();
                    }
                }
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
            }
        }
        finally {
            Variables.getReadLock().unlock();
            if (!finalSave) {
                this.setupChangesWriter();
            }
        }
    }

    private final void save(PrintWriter pw, String parent, SortedMap<String, Object> map) {
        for (Map.Entry<String, Object> e : map.entrySet()) {
            Pair<String, String> s;
            String name;
            if (e.getValue() == null) continue;
            if (e.getValue() instanceof TreeMap) {
                this.save(pw, String.valueOf(parent) + e.getKey() + "::", (TreeMap)e.getValue());
                continue;
            }
            String string = name = e.getKey() == null ? parent.substring(0, parent.length() - "::".length()) : String.valueOf(parent) + e.getKey();
            if (DatabaseStorage.accept(name) || (s = Classes.serialize(e.getValue())) == null) continue;
            FlatFileStorage.writeCSV(pw, name, (String)s.first, (String)s.second);
        }
    }
}

