/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.variables.Variables;
import ch.njol.skript.variables.VariablesStorage;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lib.PatPeter.SQLibrary.Database;
import lib.PatPeter.SQLibrary.MySQL;
import lib.PatPeter.SQLibrary.SQLibrary;
import lib.PatPeter.SQLibrary.SQLite;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DatabaseStorage
extends VariablesStorage {
    private static final String MISSINGINFORMATION = "The config is missing relevant information on the database";
    private Object db;
    private static Pattern variablePattern;
    private boolean monitor = false;
    private long monitor_interval;
    private static final String guid;
    private PreparedStatement writeQuery;
    private PreparedStatement deleteQuery;
    private PreparedStatement monitorQuery;
    private PreparedStatement monitorCleanUpQuery;
    private long lastRowID = -1L;

    static {
        guid = UUID.randomUUID().toString();
    }

    public static final boolean accept(String name) {
        return variablePattern == null ? false : variablePattern.matcher(name).matches();
    }

    @Override
    protected boolean load_i() {
        String type = (String)SkriptConfig.database.get("type");
        if (type == null) {
            Skript.error(MISSINGINFORMATION);
            return false;
        }
        if (type.equalsIgnoreCase("none")) {
            return true;
        }
        Plugin p = Bukkit.getPluginManager().getPlugin("SQLibrary");
        if (p == null || !(p instanceof SQLibrary)) {
            Skript.error("You need the plugin SQLibrary in order to use a database with Skript. You can download the latest version from http://dev.bukkit.org/server-mods/sqlibrary/files/");
            return false;
        }
        String pattern = (String)SkriptConfig.database.get("pattern");
        if (pattern == null) {
            Skript.error(MISSINGINFORMATION);
            return false;
        }
        try {
            variablePattern = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            Skript.error("Invalid pattern '" + pattern + "': " + e.getLocalizedMessage());
            return false;
        }
        Boolean monitor_changes = (Boolean)SkriptConfig.database.get("monitor changes");
        Timespan monitor_interval = (Timespan)SkriptConfig.database.get("monitor interval");
        if (monitor_changes == null || monitor_interval == null) {
            Skript.error(MISSINGINFORMATION);
            return false;
        }
        this.monitor = monitor_changes;
        this.monitor_interval = monitor_interval.getMilliSeconds();
        if (type.equalsIgnoreCase("mysql")) {
            String host = (String)SkriptConfig.database.get("host");
            Integer port = (Integer)SkriptConfig.database.get("port");
            String user = (String)SkriptConfig.database.get("user");
            String password = (String)SkriptConfig.database.get("password");
            String database = (String)SkriptConfig.database.get("database");
            if (host == null || port == null || user == null || password == null || database == null) {
                Skript.error(MISSINGINFORMATION);
                return false;
            }
            this.db = new MySQL(Bukkit.getLogger(), "[Skript]", host, port.intValue(), database, user, password);
        } else if (type.equalsIgnoreCase("sqlite")) {
            File f;
            String file = (String)SkriptConfig.database.get("file");
            if (file == null) {
                Skript.error(MISSINGINFORMATION);
                return false;
            }
            if (!file.endsWith(".db")) {
                file = String.valueOf(file) + ".db";
            }
            if ((f = new File(file)).exists() && !f.isFile()) {
                Skript.error("The database file must be an actual file, not a directory.");
                return false;
            }
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                Skript.error("Cannot create the database file: " + e.getLocalizedMessage());
                return false;
            }
            f = f.getAbsoluteFile();
            String name = f.getName();
            this.db = new SQLite(Bukkit.getLogger(), "[Skript]", f.getParent(), name.substring(0, name.length() - ".db".length()));
        } else {
            Skript.error("Invalid database type '" + type + "', only 'MySQL', 'SQLite' and 'none' are allowed.");
            return false;
        }
        if (!((Database)this.db).open()) {
            Skript.error("Cannot connect to the database!");
            return false;
        }
        try {
            if (this.db instanceof SQLite) {
                ((Database)this.db).query("CREATE TABLE IF NOT EXISTS variables (name         VARCHAR(500)   NOT NULL  PRIMARY KEY,type         VARCHAR(50)    ,value        VARCHAR(1000)  ,update_guid  CHAR(36)       NOT NULL)");
            } else {
                ((Database)this.db).query("CREATE TABLE IF NOT EXISTS variables (rowid        BIGINT         NOT NULL  AUTO_INCREMENT PRIMARY KEY,name         VARCHAR(500)   NOT NULL  UNIQUE,type         VARCHAR(50)    ,value        VARCHAR(1000)  ,update_guid  CHAR(36)       NOT NULL)");
            }
            this.writeQuery = ((Database)this.db).prepare("REPLACE INTO variables (name, type, value, update_guid) VALUES (?, ?, ?, ?)");
            this.deleteQuery = ((Database)this.db).prepare("DELETE FROM variables WHERE name = ?");
            this.monitorQuery = ((Database)this.db).prepare("SELECT name, type, value, rowid FROM variables WHERE rowid > ? AND update_guid != ?");
            this.monitorCleanUpQuery = ((Database)this.db).prepare("DELETE FROM variables WHERE type IS NULL AND rowid < ?");
            Statement s = null;
            try {
                s = ((Database)this.db).getConnection().createStatement();
                s.execute("SELECT name, type, value, rowid from variables");
                ResultSet r = null;
                try {
                    r = s.getResultSet();
                    this.loadVariables(r);
                }
                finally {
                    if (r != null) {
                        r.close();
                    }
                }
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        catch (SQLException e) {
            DatabaseStorage.sqlException(e);
            return false;
        }
        if (this.monitor) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!DatabaseStorage.this.closed) {
                        DatabaseStorage.this.checkDatabase();
                        long target = System.currentTimeMillis() + DatabaseStorage.this.monitor_interval;
                        do {
                            try {
                                Thread.sleep(target - System.currentTimeMillis());
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (System.currentTimeMillis() < target);
                    }
                }
            }).start();
        }
        return true;
    }

    @Override
    protected void save(String name, String type, String value) {
        try {
            if (!this.monitor && type == null) {
                assert (value == null);
                this.deleteQuery.setString(1, name);
                this.deleteQuery.executeUpdate();
            } else {
                int i = 1;
                this.writeQuery.setString(i++, name);
                this.writeQuery.setString(i++, type);
                this.writeQuery.setString(i++, value);
                this.writeQuery.setString(i++, guid);
                this.writeQuery.executeUpdate();
            }
        }
        catch (SQLException e) {
            DatabaseStorage.sqlException(e);
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.db != null) {
            ((Database)this.db).close();
        }
        this.db = null;
    }

    protected void checkDatabase() {
        if (this.db == null) {
            return;
        }
        try {
            final long lastRowID = this.lastRowID;
            this.monitorQuery.setLong(1, lastRowID);
            this.monitorQuery.setString(2, guid);
            this.monitorQuery.execute();
            ResultSet r = null;
            try {
                r = this.monitorQuery.getResultSet();
                this.loadVariables(r);
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
            new Task(Skript.getInstance(), (long)Math.ceil(1.0 * (double)this.monitor_interval / 50.0), true){

                @Override
                public void run() {
                    try {
                        DatabaseStorage.this.monitorCleanUpQuery.setLong(1, lastRowID);
                        DatabaseStorage.this.monitorCleanUpQuery.executeUpdate();
                    }
                    catch (SQLException e) {
                        DatabaseStorage.sqlException(e);
                    }
                }
            };
        }
        catch (SQLException e) {
            DatabaseStorage.sqlException(e);
        }
    }

    private void loadVariables(ResultSet r) throws SQLException {
        while (r.next()) {
            int i = 1;
            String name = r.getString(i++);
            String type = r.getString(i++);
            String value = r.getString(i++);
            this.lastRowID = r.getLong(i++);
            if (type == null) {
                Variables.setVariable(name, null, this);
                continue;
            }
            Object d = Classes.deserialize(type, value);
            if (d == null) {
                Skript.error("Cannot load the variable {" + name + "} from the database, because '" + value + "' cannot be parsed as a " + type);
                return;
            }
            Variables.setVariable(name, d, this);
        }
    }

    private static void sqlException(SQLException e) {
        Skript.error("database error: " + e.getLocalizedMessage());
        if (Skript.testing()) {
            e.printStackTrace();
        }
    }
}

