/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.util.Utils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Serializable,
Comparable<Version> {
    private static final long serialVersionUID = 8687040355286333293L;
    private final int[] version = new int[3];
    private final String postfix;
    public static final Pattern versionPattern = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+))?\\s*(.*)");

    public Version(int ... version) {
        if (version.length < 1 || version.length > 3) {
            throw new IllegalArgumentException("Versions must have a minimum of 2 and a maximum of 3 numbers (" + version.length + " numbers given)");
        }
        int i = 0;
        while (i < version.length) {
            this.version[i] = version[i];
            ++i;
        }
        this.postfix = null;
    }

    public Version(int major, int minor, String postfix) {
        this.version[0] = major;
        this.version[1] = minor;
        this.postfix = postfix;
    }

    public Version(String version) {
        Matcher m = versionPattern.matcher(version.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("'" + version + "' is not a valid version string");
        }
        int i = 0;
        while (i < 3) {
            if (m.group(i + 1) != null) {
                this.version[i] = Utils.parseInt(m.group(i + 1));
            }
            ++i;
        }
        this.postfix = m.group(m.groupCount()).isEmpty() ? null : m.group(m.groupCount());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)obj) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.version) * 31 + (this.postfix == null ? 0 : this.postfix.hashCode());
    }

    @Override
    public int compareTo(Version other) {
        int i = 0;
        while (i < this.version.length) {
            if (this.version[i] > other.version[i]) {
                return 1;
            }
            if (this.version[i] < other.version[i]) {
                return -1;
            }
            ++i;
        }
        if (this.postfix == null) {
            return other.postfix == null ? 0 : 1;
        }
        return other.postfix == null ? -1 : this.postfix.compareTo(other.postfix);
    }

    @Override
    public int compareTo(int ... other) {
        assert (other.length >= 2 && other.length <= 3);
        int i = 0;
        while (i < this.version.length) {
            if (this.version[i] > (i >= other.length ? 0 : other[i])) {
                return 1;
            }
            if (this.version[i] < (i >= other.length ? 0 : other[i])) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public boolean isSmallerThan(Version other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLargerThan(Version other) {
        return this.compareTo(other) > 0;
    }

    public boolean isStable() {
        return this.postfix.isEmpty();
    }

    public String toString() {
        return String.valueOf(this.version[0]) + "." + this.version[1] + (this.version[2] == 0 ? "" : "." + this.version[2]) + (this.postfix == null ? "" : " " + this.postfix);
    }

    public static final int compare(String v1, String v2) {
        return new Version(v1).compareTo(new Version(v2));
    }
}

