/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Color;
import ch.njol.util.Callback;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public abstract class Utils {
    private static final Random random = new Random();
    private static final String[][] plurals = new String[][]{{"fe", "ves"}, {"axe", "axes"}, {"x", "xes"}, {"ay", "ays"}, {"ey", "eys"}, {"iy", "iys"}, {"oy", "oys"}, {"uy", "uys"}, {"kie", "kies"}, {"zombie", "zombies"}, {"y", "ies"}, {"h", "hes"}, {"man", "men"}, {"us", "i"}, {"hoe", "hoes"}, {"toe", "toes"}, {"o", "oes"}, {"alias", "aliases"}, {"gas", "gases"}, {"child", "children"}, {"sheep", "sheep"}, {"", "s"}};
    private static final ChatColor[] styles = new ChatColor[]{ChatColor.BOLD, ChatColor.ITALIC, ChatColor.STRIKETHROUGH, ChatColor.UNDERLINE, ChatColor.MAGIC, ChatColor.RESET};
    private static final Map<String, String> chat = new HashMap<String, String>();
    private static final Map<String, String> englishChat = new HashMap<String, String>();
    private static final Pattern stylePattern;

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                boolean english = englishChat.isEmpty();
                chat.clear();
                ChatColor[] chatColorArray = styles;
                int n = chatColorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ChatColor style = chatColorArray[n2];
                    String[] stringArray = Language.getList("chat styles." + style.name());
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray[n4];
                        chat.put(s.toLowerCase(), style.toString());
                        if (english) {
                            englishChat.put(s.toLowerCase(), style.toString());
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        stylePattern = Pattern.compile("<([^<>]+)>");
    }

    private Utils() {
    }

    public static <T> int indexOf(T[] array, T t) {
        if (array == null) {
            return -1;
        }
        return Utils.indexOf(array, t, 0, array.length);
    }

    public static <T> int indexOf(T[] array, T t, int start, int end) {
        if (array == null) {
            return -1;
        }
        int i = start;
        while (i < end) {
            if (array[i] == null ? t == null : array[i].equals(t)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T o) {
        return Utils.indexOf(array, o) != -1;
    }

    public static <T> boolean containsAny(T[] array, T ... os) {
        if (array == null || os == null) {
            return false;
        }
        T[] TArray = os;
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (Utils.indexOf(array, o) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean containsAll(T[] array, T ... os) {
        if (array == null || os == null) {
            return false;
        }
        T[] TArray = os;
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (Utils.indexOf(array, o) == -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int indexOf(int[] array, int num) {
        if (array == null) {
            return -1;
        }
        return Utils.indexOf(array, num, 0, array.length);
    }

    public static int indexOf(int[] array, int num, int start) {
        if (array == null) {
            return -1;
        }
        return Utils.indexOf(array, num, start, array.length);
    }

    public static int indexOf(int[] array, int num, int start, int end) {
        if (array == null) {
            return -1;
        }
        int i = start;
        while (i < end) {
            if (array[i] == num) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final boolean contains(int[] array, int num) {
        return Utils.indexOf(array, num) != -1;
    }

    public static boolean containsIgnoreCase(String[] array, String s) {
        return Utils.indexOfIgnoreCase(array, s) != -1;
    }

    public static int indexOfIgnoreCase(String[] array, String s) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (a.equalsIgnoreCase(s)) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public static <T> int indexOf(Iterable<T> iter, T o) {
        assert (iter != null);
        int i = 0;
        for (T a : iter) {
            if (a.equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(Iterable<String> iter, String s) {
        assert (iter != null);
        int i = 0;
        for (String a : iter) {
            if (a.equalsIgnoreCase(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T, U> Map.Entry<T, U> containsKey(Map<T, U> map, T key) {
        assert (map != null);
        U u = map.get(key);
        if (u == null) {
            return null;
        }
        return new Pair<T, U>(key, u);
    }

    public static <U> Map.Entry<String, U> containsKeyIgnoreCase(Map<String, U> map, String key) {
        assert (map != null);
        for (Map.Entry<String, U> e : map.entrySet()) {
            if (!e.getKey().equalsIgnoreCase(key)) continue;
            return e;
        }
        return null;
    }

    public static String join(Object[] objects) {
        assert (objects != null);
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < objects.length) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(Classes.toString(objects[i]));
            ++i;
        }
        return b.toString();
    }

    public static String join(Iterable<?> objects) {
        assert (objects != null);
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Object o : objects) {
            if (!first) {
                b.append(", ");
            } else {
                first = false;
            }
            b.append(Classes.toString(o));
        }
        return b.toString();
    }

    public static <T> T random(T[] os) {
        assert (os != null && os.length != 0);
        return os[random.nextInt(os.length)];
    }

    public static <T> T getRandom(T[] os, int start) {
        assert (os != null && os.length != 0);
        return os[random.nextInt(os.length - start) + start];
    }

    public static <T> T getRandom(List<T> os) {
        assert (os != null && !os.isEmpty());
        return os.get(random.nextInt(os.size()));
    }

    public static boolean itemStacksEqual(ItemStack is1, ItemStack is2) {
        if (is1 == null || is2 == null) {
            return is1 == is2;
        }
        return is1.getTypeId() == is2.getTypeId() && is1.getDurability() == is2.getDurability() && is1.getEnchantments().equals(is2.getEnchantments());
    }

    public static <T extends Entity> T getTarget(LivingEntity entity, EntityData<T> type) {
        assert (entity != null);
        if (entity instanceof Creature) {
            return (T)(((Creature)entity).getTarget() == null || type != null && !type.isInstance((Entity)((Creature)entity).getTarget()) ? null : ((Creature)entity).getTarget());
        }
        Entity target = null;
        double targetDistanceSquared = 0.0;
        double radiusSquared = 1.0;
        Vector l = entity.getEyeLocation().toVector();
        Vector n = entity.getLocation().getDirection().normalize();
        double cos45 = Math.cos(0.7853981633974483);
        for (Entity other : type == null ? entity.getWorld().getEntities() : entity.getWorld().getEntitiesByClass(type.getType())) {
            if (other == entity || type != null && !type.isInstance(other) || target != null && !(targetDistanceSquared > other.getLocation().distanceSquared(entity.getLocation()))) continue;
            Vector t = other.getLocation().add(0.0, 1.0, 0.0).toVector().subtract(l);
            if (!(n.clone().crossProduct(t).lengthSquared() < 1.0) || !(t.normalize().dot(n) >= cos45)) continue;
            target = other;
            targetDistanceSquared = target.getLocation().distanceSquared(entity.getLocation());
        }
        return (T)target;
    }

    public static final Pair<String, Integer> getAmount(String s) {
        if (s.matches("\\d+ of .+")) {
            return new Pair<String, Integer>(s.split(" ", 3)[2], Utils.parseInt(s.split(" ", 2)[0]));
        }
        if (s.matches("\\d+ .+")) {
            return new Pair<String, Integer>(s.split(" ", 2)[1], Utils.parseInt(s.split(" ", 2)[0]));
        }
        if (s.matches("an? .+")) {
            return new Pair<String, Integer>(s.split(" ", 2)[1], 1);
        }
        return new Pair<String, Integer>(s, -1);
    }

    public static final AmountResponse getAmountWithEvery(String s) {
        if (s.matches("\\d+ of (all|every) .+")) {
            return new AmountResponse(s.split(" ", 4)[3], Utils.parseInt(s.split(" ", 2)[0]), true);
        }
        if (s.matches("\\d+ of .+")) {
            return new AmountResponse(s.split(" ", 3)[2], Utils.parseInt(s.split(" ", 2)[0]));
        }
        if (s.matches("\\d+ .+")) {
            return new AmountResponse(s.split(" ", 2)[1], Utils.parseInt(s.split(" ", 2)[0]));
        }
        if (s.matches("an? .+")) {
            return new AmountResponse(s.split(" ", 2)[1], 1);
        }
        if (s.matches("(all|every) .+")) {
            return new AmountResponse(s.split(" ", 2)[1], true);
        }
        return new AmountResponse(s);
    }

    public static final Pair<String, Boolean> getEnglishPlural(String s) {
        assert (s != null);
        if (s.isEmpty()) {
            return new Pair<String, Boolean>("", Boolean.FALSE);
        }
        String[][] stringArray = plurals;
        int n = plurals.length;
        int n2 = 0;
        while (n2 < n) {
            String[] p = stringArray[n2];
            if (s.endsWith(p[1])) {
                return new Pair<String, Boolean>(String.valueOf(s.substring(0, s.length() - p[1].length())) + p[0], Boolean.TRUE);
            }
            if (s.endsWith(p[1].toUpperCase())) {
                return new Pair<String, Boolean>(String.valueOf(s.substring(0, s.length() - p[1].length())) + p[0].toUpperCase(), Boolean.TRUE);
            }
            ++n2;
        }
        return new Pair<String, Boolean>(s, Boolean.FALSE);
    }

    public static final String toEnglishPlural(String s) {
        assert (s != null && s.length() != 0);
        String[][] stringArray = plurals;
        int n = plurals.length;
        int n2 = 0;
        while (n2 < n) {
            String[] p = stringArray[n2];
            if (s.endsWith(p[0])) {
                return String.valueOf(s.substring(0, s.length() - p[0].length())) + p[1];
            }
            ++n2;
        }
        assert (false);
        return String.valueOf(s) + "s";
    }

    public static final String toEnglishPlural(String s, boolean p) {
        if (p) {
            return Utils.toEnglishPlural(s);
        }
        return s;
    }

    public static final String a(String s) {
        return Utils.a(s, false);
    }

    public static final String A(String s) {
        return Utils.a(s, true);
    }

    public static final String a(String s, boolean capA) {
        assert (s != null && s.length() != 0);
        if ("aeiouAEIOU".indexOf(s.charAt(0)) != -1) {
            if (capA) {
                return "An " + s;
            }
            return "an " + s;
        }
        if (capA) {
            return "A " + s;
        }
        return "a " + s;
    }

    public static double getBlockHeight(Material type) {
        assert (type != null);
        switch (type) {
            case DIODE_BLOCK_OFF: 
            case DIODE_BLOCK_ON: {
                return 0.125;
            }
            case TRAP_DOOR: {
                return 0.1875;
            }
            case CAKE_BLOCK: {
                return 0.4375;
            }
            case STEP: {
                return 0.5;
            }
            case BED_BLOCK: {
                return 0.5625;
            }
            case ENCHANTMENT_TABLE: {
                return 0.75;
            }
            case ENDER_PORTAL_FRAME: {
                return 0.8125;
            }
            case SOUL_SAND: {
                return 0.875;
            }
            case BREWING_STAND: {
                return 0.875;
            }
            case FENCE: 
            case FENCE_GATE: 
            case NETHER_FENCE: {
                return 1.5;
            }
            case CAULDRON: {
                return 0.3125;
            }
        }
        return 1.0;
    }

    public static final String prepareMessage(String message) {
        assert (message != null);
        message = Utils.replaceChatStyles(message);
        message = StringUtils.fixCapitalization(message);
        return message;
    }

    public static final String replaceChatStyles(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        message = StringUtils.replaceAll(message.replace("<<none>>", ""), stylePattern, new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                Color c = Color.byName(m.group(1));
                if (c != null) {
                    return c.getChat();
                }
                String f = (String)chat.get(m.group(1).toLowerCase());
                if (f != null) {
                    return f;
                }
                return m.group();
            }
        });
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    public static final String replaceEnglishChatStyles(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        message = StringUtils.replaceAll(message, stylePattern, new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                Color c = Color.byName(m.group(1));
                if (c != null) {
                    return c.getChat();
                }
                String f = (String)chat.get(m.group(1).toLowerCase());
                if (f != null) {
                    return f;
                }
                return m.group();
            }
        });
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    public static final int[] permutation(int start, int end) {
        int length = end - start + 1;
        int[] r = new int[length];
        int i = 0;
        while (i < length) {
            r[i] = start + i;
            ++i;
        }
        i = 0;
        while (i < length) {
            int j = random.nextInt(length);
            int b = r[i];
            r[i] = r[j];
            r[j] = b;
            ++i;
        }
        return r;
    }

    public static final int[] permutation(int length) {
        return Utils.permutation(0, length - 1);
    }

    public static int random(int start, int end) {
        if (end <= start) {
            throw new IllegalArgumentException("end (" + end + ") must be > start (" + start + ")");
        }
        return start + random.nextInt(end - start);
    }

    public static final Class<?> getSuperType(Class<?> ... cs) {
        assert (cs.length > 0);
        Class<?> r = cs[0];
        Class<?>[] classArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                Class<?> c = classArray[n2];
                assert (!c.isArray() && !c.isPrimitive());
                if (c.isAssignableFrom(r)) {
                    r = c;
                } else if (!r.isAssignableFrom(c)) {
                    Class<?> s = c;
                    while ((s = s.getSuperclass()) != null) {
                        if (s == Object.class || !s.isAssignableFrom(r)) continue;
                        r = s;
                        break block9;
                    }
                    Class<?>[] classArray2 = c.getInterfaces();
                    int n3 = classArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Class<?> i = classArray2[n4];
                        s = Utils.getSuperType(i, r);
                        if (s != Object.class) {
                            r = s;
                            break block9;
                        }
                        ++n4;
                    }
                    return Object.class;
                }
            }
            ++n2;
        }
        return r;
    }

    public static boolean isSubset(Object[] set, Object[] sub) {
        Object[] objectArray = set;
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            if (!Utils.contains(sub, s)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final int parseInt(String s) {
        assert (s.matches("-?\\d+"));
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return s.startsWith("-") ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
    }

    public static final long parseLong(String s) {
        assert (s.matches("-?\\d+"));
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return s.startsWith("-") ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
    }

    public static <T> T[] array(T ... array) {
        return array;
    }

    public static final class AmountResponse {
        public final String s;
        public final int amount;
        public final boolean every;

        public AmountResponse(String s, int amount, boolean every) {
            this.s = s;
            this.amount = amount;
            this.every = every;
        }

        public AmountResponse(String s, boolean every) {
            this.s = s;
            this.amount = -1;
            this.every = every;
        }

        public AmountResponse(String s, int amount) {
            this.s = s;
            this.amount = amount;
            this.every = false;
        }

        public AmountResponse(String s) {
            this.s = s;
            this.amount = -1;
            this.every = false;
        }
    }
}

