/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.Noun;
import ch.njol.util.Kleenean;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.material.Directional;
import org.bukkit.util.Vector;

public class Direction
implements Serializable {
    public static final Direction ZERO = new Direction(new double[]{0.0, 0.0, 0.0});
    public static final Direction IDENTITY = new Direction(0.0, 0.0, 1.0);
    public static final BlockFace BF_X = Direction.findFace(1, 0, 0);
    public static final BlockFace BF_Y = Direction.findFace(0, 1, 0);
    public static final BlockFace BF_Z = Direction.findFace(0, 0, 1);
    public static final Noun m_meter = new Noun("directions.meter");
    private final double[] mod;
    private final double pitch;
    private final double yaw;
    private final double length;
    private final boolean relative;
    public static final double IGNORE_PITCH = 61863.0;
    private static final Message m_at = new Message("directions.at");
    private static final Message[] absoluteDirections = new Message[6];
    private static final Message[] relativeDirections = new Message[6];

    static {
        String[] rd = new String[]{"front", "behind", "left", "right", "above", "below"};
        int i = 0;
        while (i < rd.length) {
            Direction.relativeDirections[i] = new Message("directions." + rd[i]);
            ++i;
        }
        String[] ad = new String[]{BF_X.name().toLowerCase(Locale.ENGLISH), BF_X.getOppositeFace().name().toLowerCase(Locale.ENGLISH), BF_Y.name().toLowerCase(Locale.ENGLISH), BF_Y.getOppositeFace().name().toLowerCase(Locale.ENGLISH), BF_Z.name().toLowerCase(Locale.ENGLISH), BF_Z.getOppositeFace().name().toLowerCase(Locale.ENGLISH)};
        int i2 = 0;
        while (i2 < ad.length) {
            Direction.absoluteDirections[i2] = new Message("directions." + ad[i2]);
            ++i2;
        }
    }

    private static final BlockFace findFace(int x, int y, int z) {
        BlockFace[] blockFaceArray = BlockFace.values();
        int n = blockFaceArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlockFace f = blockFaceArray[n2];
            if (f.getModX() == x && f.getModY() == y && f.getModZ() == z) {
                return f;
            }
            ++n2;
        }
        assert (false);
        return null;
    }

    public Direction(double[] mod) {
        if (mod == null || mod.length != 3) {
            throw new IllegalArgumentException();
        }
        this.mod = mod;
        this.relative = false;
        this.length = 0.0;
        this.yaw = 0.0;
        this.pitch = 0.0;
    }

    public Direction(double pitch, double yaw, double length) {
        this.pitch = pitch;
        this.yaw = yaw;
        this.length = length;
        this.relative = true;
        this.mod = null;
    }

    public Direction(BlockFace f, double length) {
        this(new Vector(f.getModX(), f.getModY(), f.getModZ()).normalize().multiply(length));
    }

    public Direction(Vector v) {
        this.mod = new double[]{v.getX(), v.getY(), v.getZ()};
        this.relative = false;
        this.length = 0.0;
        this.yaw = 0.0;
        this.pitch = 0.0;
    }

    public Location getRelative(Location l) {
        return l.clone().add(this.getDirection(l));
    }

    public Location getRelative(Entity e) {
        return e.getLocation().add(this.getDirection(e.getLocation()));
    }

    public Location getRelative(Block b) {
        return b.getLocation().add(this.getDirection(b));
    }

    public Vector getDirection(Location l) {
        if (!this.relative) {
            return new Vector(this.mod[0], this.mod[1], this.mod[2]);
        }
        return this.getDirection(this.pitch == 61863.0 ? 0.0 : Direction.pitchToRadians(l.getPitch()), Direction.yawToRadians(l.getYaw()));
    }

    public Vector getDirection(Entity e) {
        return this.getDirection(e.getLocation());
    }

    public Vector getDirection(Block b) {
        if (!this.relative) {
            return new Vector(this.mod[0], this.mod[1], this.mod[2]);
        }
        Material m = b.getType();
        if (!Directional.class.isAssignableFrom(m.getData())) {
            return new Vector();
        }
        BlockFace f = ((Directional)m.getNewData(b.getData())).getFacing();
        return this.getDirection(this.pitch == 61863.0 ? 0.0 : (double)f.getModZ() * Math.PI / 2.0, Math.atan2(f.getModZ(), f.getModX()));
    }

    private Vector getDirection(double p, double y) {
        if (this.pitch == 61863.0) {
            return new Vector(Math.cos(y + this.yaw) * this.length, 0.0, Math.sin(y + this.yaw) * this.length);
        }
        double lxz = Math.cos(p + this.pitch) * this.length;
        return new Vector(Math.cos(y + this.yaw) * lxz, Math.sin(p + this.pitch) * Math.cos(this.yaw) * this.length, Math.sin(y + this.yaw) * lxz);
    }

    public int hashCode() {
        return this.relative ? Arrays.asList(this.pitch, this.yaw, this.length).hashCode() : Arrays.hashCode(this.mod);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Direction)) {
            return false;
        }
        Direction other = (Direction)obj;
        return this.relative == other.relative && (this.relative ? this.pitch == other.pitch && this.yaw == other.yaw && other.length == this.length : Arrays.equals(this.mod, other.mod));
    }

    public boolean isRelative() {
        return this.relative;
    }

    public static final double pitchToRadians(float pitch) {
        return -Math.toRadians(pitch);
    }

    public static final float getPitch(double pitch) {
        return (float)Math.toDegrees(-pitch);
    }

    public static final double yawToRadians(float yaw) {
        return Math.toRadians(yaw) + 1.5707963267948966;
    }

    public static final float getYaw(double yaw) {
        return (float)Math.toDegrees(yaw - 1.5707963267948966);
    }

    public static final BlockFace getFacing(Block b) {
        Material m = b.getType();
        if (!Directional.class.isAssignableFrom(m.getData())) {
            return BlockFace.SELF;
        }
        return ((Directional)m.getNewData(b.getData())).getFacing();
    }

    public static final BlockFace getFacing(Location l, boolean horizontal) {
        double pitch;
        double yaw = (Direction.yawToRadians(l.getYaw()) + Math.PI * 2) % (Math.PI * 2);
        double d = pitch = horizontal ? 0.0 : Direction.pitchToRadians(l.getPitch());
        if (horizontal || -0.7853981633974483 < pitch && pitch < 0.7853981633974483) {
            if (yaw < 0.7853981633974483 || yaw >= 5.497787143782138) {
                return BF_X;
            }
            if (yaw < 2.356194490192345) {
                return BF_Z;
            }
            if (yaw < 3.9269908169872414) {
                return BF_X.getOppositeFace();
            }
            assert (yaw < 5.497787143782138);
            return BF_Z.getOppositeFace();
        }
        if (pitch > 0.0) {
            return BlockFace.UP;
        }
        return BlockFace.DOWN;
    }

    public static final Location[] getRelatives(Block[] blocks, Direction[] directions) {
        Location[] r = new Location[blocks.length * directions.length];
        if (r.length == 0) {
            return r;
        }
        int i = 0;
        while (i < blocks.length) {
            r[i] = blocks[i].getLocation();
            int j = 0;
            while (j < directions.length) {
                r[i].add(directions[j].getDirection(blocks[i]));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public static final Location[] getRelatives(Location[] locations, Direction[] directions) {
        Location[] r = new Location[locations.length * directions.length];
        if (r.length == 0) {
            return r;
        }
        int i = 0;
        while (i < locations.length) {
            r[i] = locations[i].clone();
            int j = 0;
            while (j < directions.length) {
                r[i].add(directions[j].getDirection(locations[i]));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public String toString() {
        return this.relative ? Direction.toString(this.pitch == 61863.0 ? 0.0 : this.pitch, this.yaw, this.length) : Direction.toString(this.mod);
    }

    public static final String toString(double pitch, double yaw, double length) {
        double front = Math.cos(pitch) * Math.cos(yaw) * length;
        double left = Math.cos(pitch) * Math.sin(yaw) * length;
        double above = Math.sin(pitch) * length;
        return Direction.toString(new double[]{front, left, above}, relativeDirections);
    }

    public static final String toString(double[] mod) {
        if (mod[0] == 0.0 && mod[1] == 0.0 && mod[2] == 0.0) {
            return m_at.toString();
        }
        return Direction.toString(mod, absoluteDirections);
    }

    public static final String toString(Vector dir) {
        if (dir.getX() == 0.0 && dir.getY() == 0.0 && dir.getZ() == 0.0) {
            return Language.get("directions.at");
        }
        return Direction.toString(new double[]{dir.getX(), dir.getY(), dir.getZ()}, absoluteDirections);
    }

    private static final String toString(double[] mod, Message[] names) {
        assert (mod.length == 3 && names.length == 6);
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < 3) {
            Direction.toString(b, mod[i], names[2 * i], names[2 * i + 1], b.length() != 0);
            ++i;
        }
        return b.toString();
    }

    private static final void toString(StringBuilder b, double d, Message direction, Message oppositeDirection, boolean prependAnd) {
        if (d == 0.0) {
            return;
        }
        if (prependAnd) {
            b.append(" ").append(Language.m_and).append(" ");
        }
        if (d != 1.0 && d != -1.0) {
            b.append(m_meter.toString(Math.abs(d)));
            b.append(" ");
        }
        b.append(d > 0.0 ? direction : oppositeDirection);
    }

    public String serialize() {
        return this.relative + ":" + (this.relative ? String.valueOf(this.pitch) + "," + this.yaw + "," + this.length : String.valueOf(this.mod[0]) + "," + this.mod[1] + "," + this.mod[2]);
    }

    public static Direction deserialize(String s) {
        String[] split = s.split(":");
        if (split.length != 2) {
            return null;
        }
        boolean relative = Boolean.parseBoolean(split[0]);
        if (relative) {
            String[] split2 = s.split(",");
            if (split.length != 3) {
                return null;
            }
            try {
                return new Direction(Double.parseDouble(split2[0]), Double.parseDouble(split2[1]), Double.parseDouble(split2[2]));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        String[] split2 = s.split(",");
        if (split.length != 3) {
            return null;
        }
        try {
            return new Direction(new double[]{Double.parseDouble(split2[0]), Double.parseDouble(split2[1]), Double.parseDouble(split2[2])});
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static final Expression<Location> combine(final Expression<? extends Direction> dirs, final Expression<? extends Location> locs) {
        return new SimpleExpression<Location>(){
            private static final long serialVersionUID = 1316369726663020906L;

            protected Location[] get(Event e) {
                Direction[] ds = (Direction[])dirs.getArray(e);
                Location[] ls = (Location[])locs.getArray(e);
                Location[] r = ds.length == 1 ? ls : new Location[ds.length * ls.length];
                int i = 0;
                while (i < ds.length) {
                    int j = 0;
                    while (j < ls.length) {
                        r[i + j * ds.length] = ds[i].getRelative(ls[j]);
                        ++j;
                    }
                    ++i;
                }
                return r;
            }

            public Location[] getAll(Event e) {
                Direction[] ds = (Direction[])dirs.getAll(e);
                Location[] ls = (Location[])locs.getAll(e);
                Location[] r = ds.length == 1 ? ls : new Location[ds.length * ls.length];
                int i = 0;
                while (i < ds.length) {
                    int j = 0;
                    while (j < ls.length) {
                        r[i + j * ds.length] = ds[i].getRelative(ls[j]);
                        ++j;
                    }
                    ++i;
                }
                return r;
            }

            @Override
            public boolean getAnd() {
                return dirs.getAnd() && locs.getAnd();
            }

            @Override
            public boolean isSingle() {
                return dirs.isSingle() && locs.isSingle();
            }

            @Override
            public Class<? extends Location> getReturnType() {
                return Location.class;
            }

            @Override
            public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String toString(Event e, boolean debug) {
                return String.valueOf(dirs.toString(e, debug)) + " " + locs.toString(e, debug);
            }

            @Override
            public Expression<? extends Location> simplify() {
                if (dirs instanceof Literal && dirs.isSingle() && dirs.getAnd() && ((Direction)dirs.getSingle(null)).equals(ZERO)) {
                    return locs;
                }
                return this;
            }
        };
    }
}

