/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Message;
import ch.njol.skript.util.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;

public class CommandHelp {
    private static final String DEFAULTENTRY = "description";
    private static final ArgsMessage m_invalid_argument = new ArgsMessage("commands.invalid argument");
    private static final Message m_usage = new Message("commands.usage");
    private String command;
    private Message description = null;
    private final String argsColor;
    private String langNode;
    private final Map<String, Object> arguments = new LinkedHashMap<String, Object>();
    private Object wildcardArg = null;

    public CommandHelp(String command, String argsColor, String langNode) {
        this.command = command;
        this.argsColor = argsColor;
        this.langNode = langNode;
        this.description = new Message(String.valueOf(langNode) + "." + DEFAULTENTRY);
    }

    public CommandHelp(String command, String argsColor) {
        this.command = command;
        this.argsColor = argsColor;
    }

    public CommandHelp add(String argument) {
        if (argument.startsWith("<") && argument.endsWith(">")) {
            argument = "<gray><<" + this.argsColor + ">" + argument.substring(1, argument.length() - 1) + "<gray>>";
            this.wildcardArg = new Message(String.valueOf(this.langNode) + "." + argument);
        }
        this.arguments.put(argument, new Message(String.valueOf(this.langNode) + "." + argument));
        return this;
    }

    public CommandHelp add(CommandHelp help) {
        this.arguments.put(help.command, help);
        help.onAdd(this);
        return this;
    }

    protected void onAdd(CommandHelp parent) {
        this.langNode = String.valueOf(parent.langNode) + "." + this.command;
        this.description = new Message(String.valueOf(this.langNode) + "." + DEFAULTENTRY);
        this.command = String.valueOf(parent.command) + " <" + parent.argsColor + ">" + this.command;
        for (Map.Entry<String, Object> e : this.arguments.entrySet()) {
            if (e.getValue() instanceof CommandHelp) {
                ((CommandHelp)e.getValue()).onAdd(this);
                continue;
            }
            e.setValue(new Message(String.valueOf(this.langNode) + "." + e.getKey()));
        }
    }

    private static final void message(CommandSender recipient, String message) {
        recipient.sendMessage(Utils.prepareMessage(message));
    }

    public boolean test(CommandSender sender, String[] args) {
        return this.test(sender, args, 0);
    }

    private boolean test(CommandSender sender, String[] args, int index) {
        if (index >= args.length) {
            this.showHelp(sender);
            return false;
        }
        Object help = this.arguments.get(args[index].toLowerCase());
        if (help == null && this.wildcardArg == null) {
            this.showHelp(sender, m_invalid_argument.toString(this.argsColor, args[index]));
            return false;
        }
        if (help instanceof CommandHelp) {
            return ((CommandHelp)help).test(sender, args, index + 1);
        }
        return true;
    }

    public void showHelp(CommandSender sender) {
        this.showHelp(sender, m_usage.toString());
    }

    private void showHelp(CommandSender sender, String pre) {
        CommandHelp.message(sender, String.valueOf(pre) + " " + this.command + " <" + this.argsColor + ">...");
        for (Map.Entry<String, Object> e : this.arguments.entrySet()) {
            CommandHelp.message(sender, "  <" + this.argsColor + ">" + e.getKey() + " <gray>-<reset> " + e.getValue());
        }
    }

    public String toString() {
        return this.description.toString();
    }
}

