/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class AABB
implements Iterable<Block> {
    private final World world;
    private final Vector lowerBound;
    private final Vector upperBound;

    public AABB(Location l1, Location l2) {
        if (l1.getWorld() != l2.getWorld()) {
            throw new IllegalArgumentException("Locations must be in the same world");
        }
        this.world = l1.getWorld();
        this.lowerBound = new Vector(Math.min(l1.getX(), l2.getX()), Math.min(l1.getY(), l2.getY()), Math.min(l1.getZ(), l2.getZ()));
        this.upperBound = new Vector(Math.max(l1.getX(), l2.getX()), Math.max(l1.getY(), l2.getY()), Math.max(l1.getZ(), l2.getZ()));
    }

    public AABB(Block b1, Block b2) {
        if (b1.getWorld() != b2.getWorld()) {
            throw new IllegalArgumentException("Blocks must be in the same world");
        }
        this.world = b1.getWorld();
        this.lowerBound = new Vector(Math.min(b1.getX(), b2.getX()), Math.min(b1.getY(), b2.getY()), Math.min(b1.getZ(), b2.getZ()));
        this.upperBound = new Vector(Math.max(b1.getX(), b2.getX()) + 1, Math.max(b1.getY(), b2.getY()) + 1, Math.max(b1.getZ(), b2.getZ()) + 1);
    }

    public AABB(Location center, double rX, double rY, double rZ) {
        this.world = center.getWorld();
        this.lowerBound = new Vector(center.getX() - rX, Math.max(center.getY() - rY, 0.0), center.getZ() - rZ);
        this.upperBound = new Vector(center.getX() + rX, Math.min(center.getY() + rY, (double)this.world.getMaxHeight()), center.getZ() + rZ);
    }

    public boolean contains(Location l) {
        if (l.getWorld() != this.world) {
            return false;
        }
        return this.lowerBound.getX() - 1.0E-10 < l.getX() && l.getX() < this.upperBound.getX() + 1.0E-10 && this.lowerBound.getY() - 1.0E-10 < l.getY() && l.getY() < this.upperBound.getY() + 1.0E-10 && this.lowerBound.getZ() - 1.0E-10 < l.getZ() && l.getZ() < this.upperBound.getZ() + 1.0E-10;
    }

    public boolean contains(Block b) {
        return this.contains(b.getLocation()) && this.contains(b.getLocation().add(1.0, 1.0, 1.0));
    }

    public Vector getDimensions() {
        return this.upperBound.clone().subtract(this.lowerBound);
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public Iterator<Block> iterator() {
        return new Iterator<Block>(){
            private final int minX;
            private final int minY;
            private final int minZ;
            private final int maxX;
            private final int maxY;
            private final int maxZ;
            private int x;
            private int y;
            private int z;
            {
                this.minX = (int)Math.ceil(AABB.this.lowerBound.getX() - 1.0E-10);
                this.minY = (int)Math.ceil(AABB.this.lowerBound.getY() - 1.0E-10);
                this.minZ = (int)Math.ceil(AABB.this.lowerBound.getZ() - 1.0E-10);
                this.maxX = (int)Math.floor(AABB.this.upperBound.getX() + 1.0E-10) - 1;
                this.maxY = (int)Math.floor(AABB.this.upperBound.getY() + 1.0E-10) - 1;
                this.maxZ = (int)Math.floor(AABB.this.upperBound.getZ() + 1.0E-10) - 1;
                this.x = this.minX - 1;
                this.y = this.minY;
                this.z = this.minZ;
            }

            @Override
            public boolean hasNext() {
                return this.x < this.maxX || this.y < this.maxY || this.z < this.maxZ;
            }

            @Override
            public Block next() {
                ++this.x;
                if (this.x > this.maxX) {
                    this.x = this.minX;
                    ++this.z;
                    if (this.z > this.maxZ) {
                        this.z = this.minZ;
                        ++this.y;
                    }
                }
                if (this.y > this.maxY) {
                    throw new NoSuchElementException();
                }
                return AABB.this.world.getBlockAt(this.x, this.y, this.z);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

