/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.registrations;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.classes.InverseComparator;
import ch.njol.skript.classes.SerializableConverter;
import ch.njol.skript.registrations.Converters;
import ch.njol.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Comparators {
    public static final Collection<Comparator.ComparatorInfo<?, ?>> comparators = new ArrayList();
    private static final Map<Pair<Class<?>, Class<?>>, Comparator<?, ?>> comparatorsQuickAccess = new HashMap();

    private Comparators() {
    }

    public static <T1, T2> void registerComparator(Class<T1> t1, Class<T2> t2, Comparator<T1, T2> c) {
        Skript.checkAcceptRegistrations();
        if (t1 == Object.class && t2 == Object.class) {
            throw new IllegalArgumentException("You must not add a comparator for Objects");
        }
        comparators.add(new Comparator.ComparatorInfo<T1, T2>(t1, t2, c));
    }

    public static final Comparator.Relation compare(Object o1, Object o2) {
        assert (o1 != null && o2 != null);
        Comparator<?, ?> c = Comparators.getComparator(o1.getClass(), o2.getClass());
        if (c == null) {
            return null;
        }
        return c.compare(o1, o2);
    }

    public static final <F, S> Comparator<? super F, ? super S> getComparator(Class<F> f, Class<S> s) {
        Pair<Class<F>, Class<S>> p = new Pair<Class<F>, Class<S>>(f, s);
        if (comparatorsQuickAccess.containsKey(p)) {
            return comparatorsQuickAccess.get(p);
        }
        Comparator<?, ?> comp = Comparators.getComparator_i(f, s);
        comparatorsQuickAccess.put(p, comp);
        return comp;
    }

    private static final <F, S> Comparator<?, ?> getComparator_i(Class<F> f, Class<S> s) {
        SerializableConverter<F, ?> c1;
        SerializableConverter<S, ?> c2;
        boolean first;
        int n;
        int n2;
        boolean[] blArray;
        for (Comparator.ComparatorInfo<?, ?> info : comparators) {
            if (info.c1.isAssignableFrom(f) && info.c2.isAssignableFrom(s)) {
                return info.c;
            }
            if (!info.c1.isAssignableFrom(s) || !info.c2.isAssignableFrom(f)) continue;
            return new InverseComparator(info.c);
        }
        if (s == f && f != Object.class && s != Object.class) {
            return Comparator.equalsComparator;
        }
        boolean[] blArray2 = new boolean[2];
        blArray2[0] = true;
        boolean[] trueFalse = blArray2;
        for (Comparator.ComparatorInfo<?, ?> info : comparators) {
            blArray = trueFalse;
            n2 = trueFalse.length;
            n = 0;
            while (n < n2) {
                first = blArray[n];
                if (info.getType(first).isAssignableFrom(f) && (c2 = Converters.getConverter(s, info.getType(!first))) != null) {
                    return first ? new ConvertedComparator(info.c, c2) : new InverseComparator(new ConvertedComparator(c2, info.c));
                }
                if (info.getType(first).isAssignableFrom(s) && (c1 = Converters.getConverter(f, info.getType(!first))) != null) {
                    return !first ? new ConvertedComparator(c1, info.c) : new InverseComparator(new ConvertedComparator(info.c, c1));
                }
                ++n;
            }
        }
        for (Comparator.ComparatorInfo<?, ?> info : comparators) {
            blArray = trueFalse;
            n2 = trueFalse.length;
            n = 0;
            while (n < n2) {
                first = blArray[n];
                c1 = Converters.getConverter(f, info.getType(first));
                c2 = Converters.getConverter(s, info.getType(!first));
                if (c1 != null && c2 != null) {
                    return first ? new ConvertedComparator<F, S>(c1, info.c, c2) : new InverseComparator<F, S>(new ConvertedComparator<S, F>(c2, info.c, c1));
                }
                ++n;
            }
        }
        return null;
    }

    private static final class ConvertedComparator<T1, T2>
    implements Comparator<T1, T2> {
        private final Comparator c;
        private final Converter c1;
        private final Converter c2;

        public ConvertedComparator(Converter<? super T1, ?> c1, Comparator<?, ?> c) {
            this.c1 = c1;
            this.c = c;
            this.c2 = null;
        }

        public ConvertedComparator(Comparator<?, ?> c, Converter<? super T2, ?> c2) {
            this.c1 = null;
            this.c = c;
            this.c2 = c2;
        }

        public ConvertedComparator(Converter<? super T1, ?> c1, Comparator<?, ?> c, Converter<? super T2, ?> c2) {
            this.c1 = c1;
            this.c = c;
            this.c2 = c2;
        }

        @Override
        public Comparator.Relation compare(T1 o1, T2 o2) {
            return this.c.compare(this.c1 == null ? o1 : this.c1.convert(o1), this.c2 == null ? o2 : this.c2.convert(o2));
        }

        @Override
        public boolean supportsOrdering() {
            return this.c.supportsOrdering();
        }

        public String toString() {
            return "ConvertedComparator(" + this.c1 + "," + this.c + "," + this.c2 + ")";
        }
    }
}

