/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.config.Node;
import ch.njol.skript.log.HandlerList;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.Verbosity;
import java.util.Collection;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public abstract class SkriptLogger {
    private static Node node = null;
    private static Verbosity verbosity = Verbosity.NORMAL;
    static boolean debug;
    private static final HandlerList handlers;

    static {
        handlers = new HandlerList();
    }

    public static final RetainingLogHandler startRetainingLog() {
        RetainingLogHandler h = new RetainingLogHandler();
        handlers.add(h);
        return h;
    }

    public static final ParseLogHandler startParseLogHandler() {
        ParseLogHandler h = new ParseLogHandler();
        handlers.add(h);
        return h;
    }

    public static final <T extends LogHandler> T startLogHandler(T h) {
        handlers.add(h);
        return h;
    }

    static final void removeHandler(LogHandler h) {
        if (!handlers.contains(h)) {
            return;
        }
        if (handlers.remove() != h) {
            int i = 1;
            while (handlers.remove() != h) {
                ++i;
            }
            Bukkit.getLogger().severe("[Skript] " + i + " log handler" + (i == 1 ? " was" : "s were") + " not stopped properly! (at " + SkriptLogger.getCaller() + ") [if you're a server admin and you see this message please file a bug report at http://dev.bukkit.org/server-mods/skript/tickets/ if there is not already one]");
        }
    }

    static final StackTraceElement getCaller() {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (!e.getClassName().startsWith(SkriptLogger.class.getPackage().getName())) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static void setVerbosity(Verbosity v) {
        verbosity = v;
        if (v.compareTo(Verbosity.DEBUG) >= 0) {
            debug = true;
        }
    }

    public static void setNode(Node node) {
        SkriptLogger.node = node == null || node.getParent() == null ? null : node;
    }

    public static Node getNode() {
        return node;
    }

    public static void log(Level level, String message) {
        SkriptLogger.log(new LogEntry(level, message, node));
    }

    public static void log(LogEntry entry) {
        if (entry == null) {
            return;
        }
        for (LogHandler h : handlers) {
            if (h.log(entry)) continue;
            return;
        }
        Bukkit.getLogger().log(entry.getLevel(), "[Skript] " + entry.getMessage());
    }

    public static void logAll(Collection<LogEntry> entries) {
        block0: for (LogEntry entry : entries) {
            assert (entry != null);
            for (LogHandler h : handlers) {
                if (!h.log(entry)) continue block0;
            }
            Bukkit.getLogger().log(entry.getLevel(), "[Skript] " + entry.getMessage());
        }
    }

    public static boolean log(Verbosity minVerb) {
        return minVerb.compareTo(verbosity) <= 0;
    }

    public static boolean debug() {
        return debug;
    }
}

