/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.SkriptLogger;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class RetainingLogHandler
extends LogHandler {
    private final Deque<LogEntry> log = new LinkedList<LogEntry>();
    private int numErrors = 0;

    @Override
    public boolean log(LogEntry entry) {
        this.log.add(entry);
        if (entry.getLevel() == Level.SEVERE) {
            ++this.numErrors;
        }
        return false;
    }

    @Override
    public void onStop() {
    }

    public final boolean printErrors(String def) {
        this.stop();
        boolean hasError = false;
        for (LogEntry e : this.log) {
            if (e.getLevel() != Level.SEVERE) continue;
            SkriptLogger.log(e);
            hasError = true;
        }
        if (!hasError && def != null) {
            SkriptLogger.log(Level.SEVERE, def);
        }
        return hasError;
    }

    public final boolean printErrors(CommandSender recipient, String def) {
        if (recipient == Bukkit.getConsoleSender()) {
            return this.printErrors(def);
        }
        this.stop();
        boolean hasError = false;
        for (LogEntry e : this.log) {
            if (e.getLevel() != Level.SEVERE) continue;
            recipient.sendMessage(e.getMessage());
            hasError = true;
        }
        if (!hasError && def != null) {
            recipient.sendMessage(def);
        }
        return hasError;
    }

    public final void printLog() {
        this.stop();
        SkriptLogger.logAll(this.log);
    }

    public boolean hasErrors() {
        return this.numErrors != 0;
    }

    public LogEntry getFirstError() {
        for (LogEntry e : this.log) {
            if (e.getLevel() != Level.SEVERE) continue;
            return e;
        }
        return null;
    }

    public LogEntry getFirstError(String def) {
        for (LogEntry e : this.log) {
            if (e.getLevel() != Level.SEVERE) continue;
            return e;
        }
        return new LogEntry(Level.SEVERE, def);
    }

    public void clear() {
        this.log.clear();
        this.numErrors = 0;
    }

    public int size() {
        return this.log.size();
    }

    public Collection<LogEntry> getLog() {
        return Collections.unmodifiableCollection(this.log);
    }

    public int getNumErrors() {
        return this.numErrors;
    }
}

