/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.SkriptLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class ParseLogHandler
extends LogHandler {
    private LogEntry error = null;
    private final List<LogEntry> log = new ArrayList<LogEntry>();

    @Override
    public boolean log(LogEntry entry) {
        if (entry.getLevel() == Level.SEVERE) {
            if (this.error == null || entry.getQuality() > this.error.getQuality()) {
                this.error = entry;
            }
        } else {
            this.log.add(entry);
        }
        return false;
    }

    public void stop(boolean error) {
        SkriptLogger.removeHandler(this);
        if (error) {
            SkriptLogger.log(this.error);
        } else {
            for (LogEntry e : this.log) {
                SkriptLogger.log(e);
            }
        }
    }

    @Override
    public void onStop() {
    }

    public void error(String error, ErrorQuality quality) {
        this.log(new LogEntry(Level.SEVERE, quality, error));
    }

    public void clear() {
        this.log.clear();
    }

    public void printLog() {
        this.stop();
        SkriptLogger.logAll(this.log);
    }

    public void printError() {
        this.printError(null);
    }

    public void printError(String def) {
        this.stop();
        if (this.error == null && def == null) {
            return;
        }
        if (this.error == null) {
            SkriptLogger.log(new LogEntry(Level.SEVERE, def));
        } else {
            SkriptLogger.log(this.error);
        }
    }

    public int getNumErrors() {
        return this.error == null ? 0 : 1;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public LogEntry getError() {
        return this.error;
    }
}

