/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.localization;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.Message;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexMessage
extends Message {
    private final String prefix;
    private final String suffix;
    private final int flags;
    private Pattern pattern = null;

    public RegexMessage(String key, String prefix, String suffix, int flags) {
        super(key);
        this.prefix = prefix;
        this.suffix = suffix;
        this.flags = flags;
    }

    public RegexMessage(String key, String prefix, String suffix) {
        this(key, prefix, suffix, 0);
    }

    @Override
    protected String getValue() {
        return String.valueOf(this.prefix) + super.getValue() + this.suffix;
    }

    public Pattern getPattern() {
        this.validate();
        return this.pattern;
    }

    @Override
    protected void onValueChange() {
        try {
            this.pattern = Pattern.compile(this.getValue(), this.flags);
        }
        catch (PatternSyntaxException e) {
            Skript.error("Invalid RegEx pattern '" + this.getValue() + "' found in language entry '" + this.key + "': " + e.getLocalizedMessage());
        }
    }
}

