/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.util;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.iterator.SingleItemIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.event.Event;

public class VariableString
implements Expression<String> {
    private final String name;
    private final Object[] string;
    private final boolean isSimple;
    private final String simple;
    private StringMode mode;
    public static final Map<String, Pattern> variableNames = new HashMap<String, Pattern>();

    private VariableString(String s, StringMode mode) {
        this.name = s;
        this.string = null;
        this.isSimple = true;
        this.simple = s;
        this.mode = mode;
    }

    private VariableString(String name, Object[] string, StringMode mode) {
        this.name = name;
        this.isSimple = false;
        this.simple = null;
        this.string = string;
        this.mode = mode;
    }

    public static VariableString newInstance(String s) {
        return VariableString.newInstance(s, StringMode.MESSAGE);
    }

    public static final boolean isQuotedCorrectly(String s, boolean withQuotes) {
        if (!(!withQuotes || s.startsWith("\"") && s.endsWith("\""))) {
            return false;
        }
        boolean quote = false;
        int i = withQuotes ? 1 : 0;
        while (i < (withQuotes ? s.length() - 1 : s.length())) {
            if (s.charAt(i) != '\"') {
                if (quote) {
                    return false;
                }
            } else {
                quote = !quote;
            }
            ++i;
        }
        return !quote;
    }

    public static VariableString newInstance(String s, StringMode mode) {
        if (!VariableString.isQuotedCorrectly(s, false)) {
            return null;
        }
        s = Utils.replaceChatStyles(s.replace("\"\"", "\""));
        ArrayList<Object> string = new ArrayList<Object>();
        int c = s.indexOf(37);
        if (c != -1) {
            string.add(s.substring(0, c));
            while (c != s.length()) {
                int b;
                int c2 = s.indexOf(37, c + 1);
                int a = c;
                while (c2 != -1 && (b = s.indexOf(123, a + 1)) != -1 && b < c2) {
                    a = VariableString.nextVariableBracket(s, b + 1);
                    if (a == -1) {
                        Skript.error("Missing closing bracket '}' to end variable");
                        return null;
                    }
                    c2 = s.indexOf(37, a + 1);
                }
                if (c2 == -1) {
                    Skript.error("The percent sign is used for expressions (e.g. %player%). To insert a '%' type it twice: %%.");
                    return null;
                }
                if (c + 1 == c2) {
                    string.add("%");
                } else {
                    RetainingLogHandler log = SkriptLogger.startRetainingLog();
                    try {
                        Expression expr = SkriptParser.parseExpression(s.substring(c + 1, c2), 1, ParseContext.DEFAULT, Object.class);
                        if (expr == null) {
                            log.printErrors("Can't understand this expression: " + s.substring(c + 1, c2));
                            return null;
                        }
                        string.add(expr);
                    }
                    finally {
                        log.stop();
                    }
                    log.printLog();
                }
                c = s.indexOf(37, c2 + 1);
                if (c == -1) {
                    c = s.length();
                }
                string.add(s.substring(c2 + 1, c));
            }
        } else {
            string.add(s);
        }
        VariableString.checkVariableConflicts(s, mode, string);
        if (c == -1) {
            return new VariableString(s, mode);
        }
        return new VariableString(s, string.toArray(), mode);
    }

    private static void checkVariableConflicts(String name, StringMode mode, Iterable<Object> string) {
        if (mode == StringMode.VARIABLE_NAME && !variableNames.containsKey(name)) {
            Pattern pattern;
            if (name.startsWith("%")) {
                Skript.warning("Starting a variable's name with an expression is discouraged ({" + name + "}). You could prefix it with the script's name: {" + StringUtils.substring(ScriptLoader.currentScript.getFileName(), 0, -3) + "." + name + "}");
            }
            if (string != null) {
                StringBuilder p = new StringBuilder();
                block0: for (Object o : string) {
                    if (o instanceof Expression) {
                        for (ClassInfo<?> ci : Classes.getClassInfos()) {
                            if (ci.getParser() == null || !ci.getC().isAssignableFrom(((Expression)o).getReturnType())) continue;
                            p.append("(?!%)" + ci.getParser().getVariableNamePattern() + "(?<!%)");
                            continue block0;
                        }
                        p.append("[^%*](.*[^%])?");
                        continue;
                    }
                    p.append(Pattern.quote(o.toString()));
                }
                pattern = Pattern.compile(p.toString());
            } else {
                pattern = Pattern.compile(Pattern.quote(name));
            }
            if (!SkriptConfig.disableVariableConflictWarnings.value().booleanValue()) {
                for (Map.Entry<String, Pattern> e : variableNames.entrySet()) {
                    if (!e.getValue().matcher(name).matches() && !pattern.matcher(e.getKey()).matches()) continue;
                    Skript.warning("Possible name conflict of variables {" + name + "} and {" + e.getKey() + "} (there might be more conflicts).");
                    break;
                }
            }
            variableNames.put(name, pattern);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        VariableString.checkVariableConflicts(this.name, this.mode, this.string == null ? null : Arrays.asList(this.string));
    }

    public static int nextVariableBracket(String s, int start) {
        int n = 0;
        int i = start;
        while (i < s.length()) {
            if (s.charAt(i) == '}') {
                if (n == 0) {
                    return i;
                }
                --n;
            } else if (s.charAt(i) == '{') {
                ++n;
            }
            ++i;
        }
        return -1;
    }

    public static VariableString[] makeStrings(String[] args) {
        VariableString[] strings = new VariableString[args.length];
        int j = 0;
        int i = 0;
        while (i < args.length) {
            VariableString vs = VariableString.newInstance(args[i]);
            if (vs != null) {
                strings[j++] = vs;
            }
            ++i;
        }
        if (j != args.length) {
            return Arrays.copyOf(strings, j);
        }
        return strings;
    }

    public static VariableString[] makeStringsFromQuoted(List<String> args) {
        VariableString[] strings = new VariableString[args.size()];
        int i = 0;
        while (i < args.size()) {
            assert (args.get(i).startsWith("\"") && args.get(i).endsWith("\""));
            VariableString vs = VariableString.newInstance(args.get(i).substring(1, args.get(i).length() - 1));
            if (vs == null) {
                return null;
            }
            strings[i] = vs;
            ++i;
        }
        return strings;
    }

    public String toString(Event e) {
        if (this.isSimple) {
            return this.simple;
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.string.length) {
            Object o = this.string[i];
            if (o instanceof Expression) {
                b.append(Classes.toString(((Expression)o).getArray(e), ((Expression)o).getAnd(), this.mode, this.mode == StringMode.MESSAGE && (Math.abs(StringUtils.numberBefore(b, b.length() - 1)) != 1.0 || i + 1 < this.string.length && this.string[i + 1] instanceof String && StringUtils.startsWithIgnoreCase((String)this.string[i + 1], "s"))));
            } else if (this.mode == StringMode.MESSAGE && i != 0 && this.string[i - 1] instanceof Expression && StringUtils.startsWithIgnoreCase((String)o, "s")) {
                b.append(((String)o).substring(1));
            } else {
                b.append(o);
            }
            ++i;
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (this.isSimple) {
            return String.valueOf('\"') + this.simple + '\"';
        }
        StringBuilder b = new StringBuilder("\"");
        Object[] objectArray = this.string;
        int n = this.string.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Expression) {
                b.append("%" + ((Expression)o).toString(e, debug) + "%");
            } else {
                b.append(o);
            }
            ++n2;
        }
        b.append('\"');
        return b.toString();
    }

    public String getDefaultVariableName() {
        if (this.isSimple) {
            return this.simple;
        }
        StringBuilder b = new StringBuilder();
        Object[] objectArray = this.string;
        int n = this.string.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Expression) {
                b.append("<" + Classes.getSuperClassInfo(((Expression)o).getReturnType()).getCodeName() + ">");
            } else {
                b.append(o);
            }
            ++n2;
        }
        return b.toString();
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public StringMode getMode() {
        return this.mode;
    }

    public void setMode(StringMode mode) {
        this.mode = mode;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSingle(Event e) {
        return this.toString(e);
    }

    public String[] getArray(Event e) {
        return new String[]{this.toString(e)};
    }

    public String[] getAll(Event e) {
        return new String[]{this.toString(e)};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean check(Event e, Checker<? super String> c, boolean negated) {
        return SimpleExpression.check(this.getAll(e), c, negated, false);
    }

    @Override
    public boolean check(Event e, Checker<? super String> c) {
        return SimpleExpression.check(this.getAll(e), c, false, false);
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> to) {
        if (to.isAssignableFrom(String.class)) {
            return this;
        }
        return null;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getAnd() {
        return false;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Iterator<? extends String> iterator(Event e) {
        return new SingleItemIterator<String>(this.toString(e));
    }

    @Override
    public boolean isLoopOf(String s) {
        return false;
    }

    @Override
    public Expression<?> getSource() {
        return this;
    }

    public static final void setStringMode(Expression<?> e, StringMode mode) {
        if (e instanceof ExpressionList) {
            Expression<T>[] expressionArray = ((ExpressionList)e).getExpressions();
            int n = expressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Expression ex = expressionArray[n2];
                if (ex instanceof VariableString) {
                    ((VariableString)ex).setMode(mode);
                }
                ++n2;
            }
        } else if (e instanceof VariableString) {
            ((VariableString)e).setMode(mode);
        }
    }

    @Override
    public Expression<String> simplify() {
        return this;
    }
}

