/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LiteralList;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.lang.util.VariableString;
import ch.njol.skript.localization.Language;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.inventory.ItemStack;

public class SkriptParser {
    private final String expr;
    public static final int PARSE_EXPRESSIONS = 1;
    public static final int PARSE_LITERALS = 2;
    private final int flags;
    public final ParseContext context;
    public static final String wildcard = "[^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?";
    public static final String stringMatcher = "\"[^\"]*?(?:\"\"[^\"]*)*?\"";
    private static final Pattern varPattern = Pattern.compile("^((the )?var(iable)? )?\\{([^{}]|%\\{|\\}%)+\\}$", 2);
    public static final Pattern listSplitPattern = Pattern.compile("\\s*,?\\s+(and|n?or)\\s+|\\s*,\\s*", 2);
    public static final Pattern listElementPattern = Pattern.compile("((?:[^\"{}]|\"(?:[^\"]|\"\")*\"|\\{(?:[^{}]|%\\{|\\}%)+\\})+?)(?:\\s*,?\\s+(and|n?or)\\s+|\\s*,\\s*)", 2);

    private SkriptParser(String expr) {
        this(expr, 3);
    }

    private SkriptParser(String expr, int flags) {
        this(expr, flags, ParseContext.DEFAULT);
    }

    private SkriptParser(String expr, int flags, ParseContext context) {
        assert (expr != null);
        assert (flags != 0);
        this.expr = expr;
        this.flags = flags;
        this.context = context;
    }

    public static final <T> Literal<? extends T> parseLiteral(String expr, Class<T> c, ParseContext context) {
        if ((expr = expr.trim()).isEmpty()) {
            return null;
        }
        return new UnparsedLiteral(expr).getConvertedExpression(context, c);
    }

    public static final <T extends SyntaxElement> T parse(String expr, Iterator<? extends SyntaxElementInfo<T>> source, String defaultError) {
        T e;
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            e = new SkriptParser(expr).parse(source);
        }
        finally {
            log.stop();
        }
        if (e != null) {
            log.printLog();
            return e;
        }
        log.printError(defaultError);
        return null;
    }

    public static final <T extends SyntaxElement> T parseStatic(String expr, Iterator<? extends SyntaxElementInfo<? extends T>> source, String defaultError) {
        T e;
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            e = new SkriptParser(expr, 2).parse(source);
        }
        finally {
            log.stop();
        }
        if (e != null) {
            log.printLog();
            return e;
        }
        log.printError(defaultError);
        return null;
    }

    /*
     * Exception decompiling
     */
    private final <T extends SyntaxElement> T parse(Iterator<? extends SyntaxElementInfo<? extends T>> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final <T> Variable<T> parseVariable(String expr, Class<? extends T>[] returnTypes) {
        if (varPattern.matcher(expr).matches()) {
            return Variable.newInstance(expr.substring(expr.indexOf(123) + 1, expr.lastIndexOf(125)), returnTypes);
        }
        return null;
    }

    public static final <T> Expression<? extends T> parseExpression(String s, int flags, ParseContext context, Class<? extends T> ... types) {
        assert (s != null && context != null && types != null && types.length > 0);
        assert (types.length == 1 || !Utils.contains(types, Object.class));
        if (types.length == 1 && types[0] == Object.class) {
            return new SkriptParser(s, flags, context).parseObjectExpression();
        }
        return new SkriptParser(s, flags, context).parseExpression(types);
    }

    private final <T> Expression<? extends T> parseExpression(Class<? extends T> ... types) {
        assert (!Utils.contains(types, Object.class));
        LinkedList<Expression<? extends T>> ts = new LinkedList<Expression<? extends T>>();
        Kleenean and = Kleenean.UNKNOWN;
        boolean isLiteralList = true;
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Expression<? extends T> r = this.parseSingleExpr(this.expr, this.flags, types);
            if (r != null) {
                log.printLog();
                Expression<? extends T> expression = r;
                return expression;
            }
            log.clear();
            String lastExpr = this.expr;
            Matcher m = listSplitPattern.matcher(this.expr);
            int end = this.expr.length();
            int expectedEnd = -1;
            boolean last = false;
            while (m.find() || (last = !last)) {
                Expression<? extends T> t;
                if (expectedEnd == -1) {
                    expectedEnd = last ? this.expr.length() : m.start();
                }
                if ((t = this.parseSingleExpr(lastExpr = this.expr.substring(last ? 0 : m.end(), end), this.flags, types)) != null) {
                    isLiteralList &= t instanceof Literal;
                    if (!last && m.group(1) != null) {
                        if (and.isUnknown()) {
                            and = Kleenean.get(m.group(1).equalsIgnoreCase("and"));
                        } else if (and != Kleenean.get(m.group(1).equalsIgnoreCase("and"))) {
                            Skript.warning("List has multiple 'and' or 'or', will default to 'and'");
                            and = Kleenean.TRUE;
                        }
                    }
                    ts.addFirst(t);
                    if (last) break;
                    end = m.start();
                    m.region(0, end);
                    continue;
                }
                log.clear();
            }
            if (end != expectedEnd || ts.isEmpty()) {
                log.printError("'" + lastExpr + "' is " + SkriptParser.notOfType(types));
                return null;
            }
        }
        finally {
            log.stop();
        }
        log.printLog();
        if (ts.size() == 1) {
            return (Expression)ts.getFirst();
        }
        if (and.isUnknown()) {
            Skript.warning("List is missing 'and' or 'or', defaulting to 'and'");
        }
        if (isLiteralList) {
            return new LiteralList(ts.toArray(new Literal[ts.size()]), Utils.getSuperType(types), !and.isFalse());
        }
        return new ExpressionList(ts.toArray(new Expression[ts.size()]), Utils.getSuperType(types), !and.isFalse());
    }

    private final Expression<?> parseObjectExpression() {
        ParseLogHandler log;
        if ((this.flags & 1) != 0) {
            log = SkriptLogger.startParseLogHandler();
            try {
                Expression r = this.parseSingleExpr(this.expr, 1, Object.class);
                if (r != null) {
                    log.printLog();
                    Expression expression = r;
                    return expression;
                }
                if ((this.flags & 2) == 0) {
                    log.printError(null);
                    return null;
                }
            }
            finally {
                log.stop();
            }
        }
        log = SkriptLogger.startParseLogHandler();
        try {
            Expression e = this.parseExpression(Number.class);
            if (e != null) {
                log.printLog();
                Expression expression = e;
                return expression;
            }
            e = this.parseExpression(Time.class);
            if (e != null) {
                log.printLog();
                Expression expression = e;
                return expression;
            }
            e = this.parseExpression(ItemType.class);
            if (e != null) {
                log.printLog();
                Expression expression = e;
                return expression;
            }
            e = this.parseExpression(ItemStack.class);
            if (e != null) {
                log.printLog();
                Expression expression = e;
                return expression;
            }
        }
        finally {
            log.stop();
        }
        Matcher m = listElementPattern.matcher(this.expr);
        if (!m.find()) {
            return this.parseSingleExpr(this.expr, 2, Object.class);
        }
        ArrayList ts = new ArrayList();
        int start = 0;
        Kleenean and = Kleenean.UNKNOWN;
        boolean last = false;
        boolean isLiteralList = true;
        while (m.lookingAt() || (last = !last)) {
            String sub = last ? this.expr.substring(start) : m.group(1).trim();
            Expression t = this.parseSingleExpr(sub, this.flags, Object.class);
            isLiteralList &= t instanceof Literal;
            if (!last && m.group(2) != null) {
                if (and.isUnknown()) {
                    and = Kleenean.get(m.group(2).equalsIgnoreCase("and"));
                } else if (and != Kleenean.get(m.group(2).equalsIgnoreCase("and"))) {
                    Skript.warning("List has multiple 'and' and 'or', will default to 'and'");
                    and = Kleenean.TRUE;
                }
            }
            ts.add(t);
            if (last) break;
            start = m.end();
            m.region(start, this.expr.length());
        }
        assert (ts.size() > 1);
        if (and.isUnknown()) {
            Skript.warning("List is missing 'and' or 'or', defaulting to 'and'");
        }
        if (isLiteralList) {
            return new LiteralList<Object>(ts.toArray(new Literal[ts.size()]), Object.class, !and.isFalse());
        }
        return new ExpressionList<Object>(ts.toArray(new Expression[ts.size()]), Object.class, !and.isFalse());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <T> Expression<? extends T> parseSingleExpr(String s, int flags, Class<? extends T> ... types) {
        assert (types.length > 0);
        assert (types.length == 1 || !Utils.contains(types, Object.class));
        if (s.isEmpty()) {
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            void var7_22;
            Variable<? extends T> var = SkriptParser.parseVariable(this.expr, types);
            if (var != null) {
                log.stop();
                if ((flags & 1) == 0) {
                    return null;
                }
                log.printLog();
                Variable<? extends T> variable = var;
                return variable;
            }
            if (log.hasError()) {
                log.printError(null);
                return null;
            }
            log.clear();
            if ((flags & 1) != 0) {
                Expression<String> e = s.startsWith("\"") && s.endsWith("\"") && (types[0] == Object.class || Utils.contains(types, String.class)) ? VariableString.newInstance(s.substring(1, s.length() - 1)) : (Expression<String>)SkriptParser.parse(s, Skript.getExpressions(types), null);
                if (e != null) {
                    Class<? extends T>[] classArray = types;
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<T> clazz = classArray[n2];
                        if (clazz.isAssignableFrom(e.getReturnType())) {
                            log.printLog();
                            Expression<String> expression = e;
                            return expression;
                        }
                        ++n2;
                    }
                    classArray = types;
                    n = types.length;
                    n2 = 0;
                    while (n2 < n) {
                        Class<? extends T> clazz = classArray[n2];
                        Expression<? extends T> r = e.getConvertedExpression(clazz);
                        if (r != null) {
                            log.printLog();
                            Expression<? extends T> expression = r;
                            return expression;
                        }
                        ++n2;
                    }
                    log.error(String.valueOf(e.toString(null, false)) + " is " + SkriptParser.notOfType(types), ErrorQuality.NOT_AN_EXPRESSION);
                    log.printError(null);
                    return null;
                }
                log.clear();
            }
            if ((flags & 2) == 0) {
                log.printError(null);
                return null;
            }
            if (types[0] == Object.class) {
                log.stop();
                UnparsedLiteral unparsedLiteral = new UnparsedLiteral(s);
                return unparsedLiteral;
            }
            Class<? extends T>[] classArray = types;
            int n = types.length;
            boolean bl = false;
            while (var7_22 < n) {
                Class<? extends T> c = classArray[var7_22];
                log.clear();
                T t = Classes.parse(s, c, this.context);
                if (t != null) {
                    log.printLog();
                    SimpleLiteral<T> simpleLiteral = new SimpleLiteral<T>(t, false);
                    return simpleLiteral;
                }
                ++var7_22;
            }
        }
        finally {
            log.stop();
        }
        log.printError(null);
        return null;
    }

    public static boolean parseArguments(String args, ScriptCommand command, ScriptCommandEvent event) {
        SkriptParser parser = new SkriptParser(args, 2, ParseContext.COMMAND);
        ParseResult res = parser.parse_i(command.getPattern(), 0, 0);
        if (res == null) {
            return false;
        }
        List<Argument<?>> as = command.getArguments();
        assert (as.size() == res.exprs.length);
        int i = 0;
        while (i < res.exprs.length) {
            if (res.exprs[i] == null) {
                as.get(i).setToDefault(event);
            } else {
                as.get(i).set(event, res.exprs[i].getArray(event));
            }
            ++i;
        }
        return true;
    }

    public static Pair<SkriptEventInfo<?>, SkriptEvent> parseEvent(String event, String defaultError) {
        Pair<SkriptEventInfo<?>, SkriptEvent> e;
        RetainingLogHandler log = SkriptLogger.startRetainingLog();
        try {
            e = new SkriptParser(event, 2, ParseContext.EVENT).parseEvent();
        }
        finally {
            log.stop();
        }
        if (e != null) {
            log.printLog();
            return e;
        }
        log.printErrors(defaultError);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Pair<SkriptEventInfo<?>, SkriptEvent> parseEvent() {
        if (!SkriptParser.$assertionsDisabled && this.context != ParseContext.EVENT) {
            throw new AssertionError();
        }
        if (!SkriptParser.$assertionsDisabled && this.flags != 2) {
            throw new AssertionError();
        }
        log = SkriptLogger.startParseLogHandler();
        try {
            for (SkriptEventInfo<?> info : Skript.getEvents()) {
                i = 0;
                while (i < info.patterns.length) {
                    log.clear();
                    try {
                        res = this.parse_i(info.patterns[i], 0, 0);
                        if (res != null) {
                            e = (SkriptEvent)info.c.newInstance();
                            if (!e.init((Literal[])Arrays.copyOf(res.exprs, res.exprs.length, Literal[].class), i, res)) {
                                log.printError();
                                return null;
                            }
                            log.printLog();
                            var8_9 = new Pair<SkriptEventInfo<?>, SkriptEvent>(info, e);
                            return var8_9;
                        }
                    }
                    catch (InstantiationException e) {
                        if (!SkriptParser.$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    catch (IllegalAccessException e) {
                        if (SkriptParser.$assertionsDisabled) ** GOTO lbl-1000
                        throw new AssertionError();
                    }
lbl-1000:
                    // 3 sources

                    {
                        ++i;
                    }
                }
            }
        }
        finally {
            log.stop();
        }
        log.printError(null);
        return null;
    }

    private static int nextBracket(String pattern, char closingBracket, char openingBracket, int start) throws MalformedPatternException {
        int n = 0;
        int i = start;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == closingBracket) {
                if (n == 0) {
                    return i;
                }
                --n;
            } else if (pattern.charAt(i) == openingBracket) {
                ++n;
            }
            ++i;
        }
        throw new MalformedPatternException(pattern, "Missing closing bracket '" + closingBracket + "'");
    }

    private static int nextUnescaped(String pattern, char c, int from) {
        int i = from;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int countUnescaped(String pattern, char c) {
        int r = 0;
        int i = 0;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == c) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    private static int nextQuote(String s, int from) {
        int i = from;
        while (i < s.length()) {
            if (s.charAt(i) == '\"') {
                if (i == s.length() - 1 || s.charAt(i + 1) != '\"') {
                    return i;
                }
                ++i;
            }
            ++i;
        }
        return -1;
    }

    public static final String notOfType(Class<?> ... cs) {
        if (cs.length == 1) {
            return String.valueOf(Language.get("not")) + " " + Classes.getSuperClassInfo(cs[0]).getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(String.valueOf(Language.get("neither")) + " ");
        int k = 0;
        while (k < cs.length) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            b.append(Classes.getSuperClassInfo(cs[k]).getName().withIndefiniteArticle());
            ++k;
        }
        return b.toString();
    }

    public static final String notOfType(ClassInfo<?> ... cs) {
        if (cs.length == 1) {
            return String.valueOf(Language.get("not")) + " " + cs[0].getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(String.valueOf(Language.get("neither")) + " ");
        int k = 0;
        while (k < cs.length) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            b.append(cs[k].getName().withIndefiniteArticle());
            ++k;
        }
        return b.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ParseResult parse_i(String pattern, int i, int j) {
        while (j < pattern.length()) {
            switch (pattern.charAt(j)) {
                case '[': {
                    log0 = SkriptLogger.startParseLogHandler();
                    try {
                        res = this.parse_i(pattern, i, j + 1);
                        if (res != null) {
                            log0.printLog();
                            var9_9 = res;
                            return var9_9;
                        }
                        log0.clear();
                        j = SkriptParser.nextBracket(pattern, ']', '[', j + 1) + 1;
                        res = this.parse_i(pattern, i, j);
                    }
                    finally {
                        log0.stop();
                    }
                    if (res == null) {
                        log0.printError(null);
                        return res;
                    }
                    log0.printLog();
                    return res;
                }
                case '(': {
                    log = SkriptLogger.startParseLogHandler();
                    try {
                        start = j;
                        while (j < pattern.length()) {
                            log.clear();
                            if (j != start && pattern.charAt(j) != '|') ** GOTO lbl45
                            mark = -1;
                            if (j != pattern.length() - 1 && (Character.isDigit(pattern.charAt(j + 1)) || pattern.charAt(j + 1) == '-') && (j2 = pattern.indexOf(166, j + 2)) != -1) {
                                try {
                                    mark = Integer.parseInt(pattern.substring(j + 1, j2));
                                    j = j2;
                                }
                                catch (NumberFormatException var12_18) {
                                    // empty catch block
                                }
                            }
                            if ((res = this.parse_i(pattern, i, j + 1)) != null) {
                                log.printLog();
                                if (mark != -1 && res.mark == -1) {
                                    res.mark = mark;
                                }
                                var14_21 = res;
                                return var14_21;
                            }
                            ** GOTO lbl52
lbl45:
                            // 1 sources

                            if (pattern.charAt(j) != '(') ** GOTO lbl48
                            j = SkriptParser.nextBracket(pattern, ')', '(', j + 1);
                            ** GOTO lbl52
lbl48:
                            // 1 sources

                            if (pattern.charAt(j) != ')') {
                                if (j == pattern.length() - 1) {
                                    throw new MalformedPatternException(pattern, "Missing closing bracket ')'");
                                } else {
                                    ** GOTO lbl52
                                }
                            }
                            break;
lbl52:
                            // 4 sources

                            ++j;
                        }
                    }
                    finally {
                        log.stop();
                    }
                    log.printError();
                    return null;
                }
                case '%': {
                    if (i == this.expr.length()) {
                        return null;
                    }
                    end = pattern.indexOf(37, j + 1);
                    if (end == -1) {
                        throw new MalformedPatternException(pattern, "odd number of '%'");
                    }
                    name = pattern.substring(j + 1, end);
                    vi = SkriptParser.getExprInfo(name);
                    if (end == pattern.length() - 1) {
                        i2 = this.expr.length();
                    } else if (this.expr.charAt(i) == '\"') {
                        i2 = SkriptParser.nextQuote(this.expr, i + 1) + 1;
                        if (i2 == 0) {
                            return null;
                        }
                    } else if (this.expr.charAt(i) == '{') {
                        i2 = VariableString.nextVariableBracket(this.expr, i + 1) + 1;
                        if (i2 == 0) {
                            return null;
                        }
                    } else {
                        i2 = i + 1;
                    }
                    log1 = SkriptLogger.startParseLogHandler();
                    try {
                        while (i2 <= this.expr.length()) {
                            log1.clear();
                            res = this.parse_i(pattern, i2, end + 1);
                            if (res == null) ** GOTO lbl128
                            log2 = SkriptLogger.startParseLogHandler();
                            try {
                                k = 0;
                                while (k < vi.classes.length) {
                                    log2.clear();
                                    e = SkriptParser.parseExpression(this.expr.substring(i, i2), this.flags & vi.flagMask, this.context, new Class[]{vi.classes[k].getC()});
                                    if (e != null) {
                                        log2.stop();
                                        log1.stop();
                                        if (!vi.isPlural[k] && !e.isSingle()) {
                                            if (this.context == ParseContext.COMMAND) {
                                                Skript.error(Commands.m_too_many_arguments.toString(new Object[]{vi.classes[k].getName().getIndefiniteArticle(), vi.classes[k].getName().toString()}), ErrorQuality.SEMANTIC_ERROR);
                                                return null;
                                            }
                                            Skript.error("'" + this.expr.substring(0, i) + "<...>" + this.expr.substring(i2) + "' can only accept a single " + vi.classes[k].getName() + ", not more", ErrorQuality.SEMANTIC_ERROR);
                                            return null;
                                        }
                                        if (vi.time != 0) {
                                            if (e instanceof Literal) {
                                                return null;
                                            }
                                            if (ScriptLoader.hasDelayBefore == Kleenean.TRUE) {
                                                Skript.error("Cannot use time states after the event has already passed", ErrorQuality.SEMANTIC_ERROR);
                                                return null;
                                            }
                                            if (!e.setTime(vi.time)) {
                                                Skript.error(e + " does not have a " + (vi.time == -1 ? "past" : "future") + " state", ErrorQuality.SEMANTIC_ERROR);
                                                return null;
                                            }
                                        }
                                        log2.printLog();
                                        log1.printLog();
                                        res.exprs[StringUtils.count((String)pattern, (char)'%', (int)0, (int)(j - 1)) / 2] = e;
                                        var16_31 = res;
                                        return var16_31;
                                    }
                                    ++k;
                                }
                            }
                            finally {
                                log2.stop();
                            }
                            if (log2.hasError()) {
                                log2.printError(null);
                                return null;
                            }
                            Skript.error("'" + this.expr.substring(i, i2) + "' is " + SkriptParser.notOfType(vi.classes), ErrorQuality.NOT_AN_EXPRESSION);
                            return null;
lbl128:
                            // 1 sources

                            ++i2;
                        }
                    }
                    finally {
                        log1.stop();
                    }
                    log1.printError();
                    return null;
                }
                case '<': {
                    end = pattern.indexOf(62, j + 1);
                    if (end == -1) {
                        throw new MalformedPatternException(pattern, "missing closing regex bracket '>'");
                    }
                    log2 = SkriptLogger.startParseLogHandler();
                    try {
                        i2 = i + 1;
                        while (i2 <= this.expr.length()) {
                            log2.clear();
                            res = this.parse_i(pattern, i2, end + 1);
                            if (res != null && (m = Pattern.compile(pattern.substring(j + 1, end)).matcher(this.expr.substring(i, i2))).matches()) {
                                res.regexes.add(0, m.toMatchResult());
                                log2.printLog();
                                var15_33 = res;
                                return var15_33;
                            }
                            ++i2;
                        }
                    }
                    finally {
                        log2.stop();
                    }
                    log2.printError(null);
                    return null;
                }
                case ')': 
                case ']': {
                    ++j;
                    break;
                }
                case '|': {
                    j = SkriptParser.nextBracket(pattern, ')', '(', j + 1) + 1;
                    break;
                }
                case ' ': {
                    if (i == 0 || i == this.expr.length() || i > 0 && this.expr.charAt(i - 1) == ' ') {
                        ++j;
                        break;
                    }
                    if (this.expr.charAt(i) != ' ') {
                        return null;
                    }
                    ++i;
                    ++j;
                    break;
                }
                case '\\': {
                    if (++j == pattern.length()) {
                        throw new MalformedPatternException(pattern, "must not end with a backslash");
                    }
                }
                default: {
                    if (i == this.expr.length()) return null;
                    if (Character.toLowerCase(pattern.charAt(j)) != Character.toLowerCase(this.expr.charAt(i))) {
                        return null;
                    }
                    ++i;
                    ++j;
                }
            }
        }
        if (i != this.expr.length()) return null;
        if (j != pattern.length()) return null;
        return new ParseResult(this, pattern);
    }

    private static ExprInfo getExprInfo(String s) throws MalformedPatternException, IllegalArgumentException, SkriptAPIException {
        ExprInfo r = new ExprInfo();
        r.isOptional = s.startsWith("-");
        if (r.isOptional) {
            s = s.substring(1);
        }
        if (s.startsWith("*")) {
            s = s.substring(1);
            r.flagMask &= 0xFFFFFFFE;
        } else if (s.startsWith("~")) {
            s = s.substring(1);
            r.flagMask &= 0xFFFFFFFD;
        }
        int a = s.indexOf("@");
        if (a != -1) {
            r.time = Integer.parseInt(s.substring(a + 1));
            s = s.substring(0, a);
        }
        String[] classes = s.split("/");
        r.classes = new ClassInfo[classes.length];
        r.isPlural = new boolean[classes.length];
        int i = 0;
        while (i < classes.length) {
            Pair<String, Boolean> p = Utils.getEnglishPlural(classes[i]);
            r.classes[i] = Classes.getClassInfo((String)p.first);
            r.isPlural[i] = (Boolean)p.second;
            ++i;
        }
        return r;
    }

    private static final class ExprInfo {
        ClassInfo<?>[] classes;
        boolean[] isPlural;
        boolean isOptional;
        int flagMask = -1;
        int time = 0;

        private ExprInfo() {
        }
    }

    private static final class MalformedPatternException
    extends RuntimeException {
        public MalformedPatternException(String pattern, String message) {
            super(String.valueOf(message) + " [pattern: " + pattern + "]");
        }
    }

    public static final class ParseResult {
        public final Expression<?>[] exprs;
        public final List<MatchResult> regexes = new ArrayList<MatchResult>();
        public final String expr;
        public int mark = -1;

        public ParseResult(SkriptParser parser, String pattern) {
            this.expr = parser.expr;
            this.exprs = new Expression[SkriptParser.countUnescaped(pattern, '%') / 2];
        }
    }
}

