/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SyntaxElementInfo;
import java.util.Locale;
import org.bukkit.event.Event;

public final class SkriptEventInfo<E extends SkriptEvent>
extends SyntaxElementInfo<E> {
    public Class<? extends Event>[] events;
    public final String name;
    private final String id;
    private String[] description;
    private String[] examples;
    private String since;

    public SkriptEventInfo(String name, String[] patterns, Class<E> c, Class<? extends Event>[] events) throws IllegalArgumentException {
        super(patterns, c);
        assert (name != null);
        assert (patterns != null && patterns.length > 0);
        assert (c != null);
        assert (events != null && events.length > 0);
        this.events = events;
        this.name = name.startsWith("*") ? (name = name.substring(1)) : "On " + name;
        this.id = name.toLowerCase(Locale.ENGLISH).replaceAll("[#'\"<>/&]", "").replaceAll("\\s+", "_");
    }

    public SkriptEventInfo<E> description(String ... description) {
        assert (this.description == null);
        this.description = description;
        return this;
    }

    public SkriptEventInfo<E> examples(String ... examples) {
        assert (this.examples == null);
        this.examples = examples;
        return this;
    }

    public SkriptEventInfo<E> since(String since) {
        assert (this.since == null);
        this.since = since;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String[] getDescription() {
        return this.description;
    }

    public String[] getExamples() {
        return this.examples;
    }

    public String getSince() {
        return this.since;
    }
}

