/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.economy.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.hooks.economy.EconomyHook;
import ch.njol.skript.hooks.economy.expressions.Money;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

public class ExprBalance
extends SimplePropertyExpression<OfflinePlayer, Money> {
    static {
        ExprBalance.register(ExprBalance.class, Money.class, "(money|balance|[bank] account)", "players");
    }

    @Override
    public Money convert(OfflinePlayer p) {
        return new Money(EconomyHook.economy.getBalance(p.getName()));
    }

    @Override
    public Class<? extends Money> getReturnType() {
        return Money.class;
    }

    @Override
    protected String getPropertyName() {
        return "money";
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return new Class[]{Money.class};
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        if (mode == Changer.ChangeMode.DELETE) {
            OfflinePlayer[] offlinePlayerArray = (OfflinePlayer[])this.getExpr().getAll(e);
            int n = offlinePlayerArray.length;
            int n2 = 0;
            while (n2 < n) {
                OfflinePlayer p = offlinePlayerArray[n2];
                EconomyHook.economy.withdrawPlayer(p.getName(), EconomyHook.economy.getBalance(p.getName()));
                ++n2;
            }
            return;
        }
        double m = ((Money)delta).getAmount();
        OfflinePlayer[] offlinePlayerArray = (OfflinePlayer[])this.getExpr().getAll(e);
        int n = offlinePlayerArray.length;
        int n3 = 0;
        while (n3 < n) {
            OfflinePlayer p = offlinePlayerArray[n3];
            switch (mode) {
                case SET: {
                    double b = EconomyHook.economy.getBalance(p.getName());
                    if (b < m) {
                        EconomyHook.economy.depositPlayer(p.getName(), m - b);
                        break;
                    }
                    if (!(b > m)) break;
                    EconomyHook.economy.withdrawPlayer(p.getName(), b - m);
                    break;
                }
                case ADD: {
                    EconomyHook.economy.depositPlayer(p.getName(), m);
                    break;
                }
                case REMOVE: {
                    EconomyHook.economy.withdrawPlayer(p.getName(), m);
                }
            }
            ++n3;
        }
    }
}

