/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;

@Name(value="Yaw / Pitch")
@Description(value={"The yaw or pitch of a location. You likely won't need this expression ever if you don't know what this means."})
@Examples(value={"log \"%player%: %location of player%, %player's yaw%, %player's pitch%\" to \"playerlocs.log\""})
@Since(value="2.0")
public class ExprYawPitch
extends SimplePropertyExpression<Location, Float> {
    private boolean yaw;

    static {
        ExprYawPitch.register(ExprYawPitch.class, Float.TYPE, "(0\u00a6yaw|1\u00a6pitch)", "locations");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.yaw = parseResult.mark == 0;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public Float convert(Location l) {
        return Float.valueOf(this.yaw ? l.getYaw() : l.getPitch());
    }

    @Override
    public Class<? extends Float> getReturnType() {
        return Float.class;
    }

    @Override
    protected String getPropertyName() {
        return this.yaw ? "yaw" : "pitch";
    }
}

