/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.WrapperExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;

@Name(value="Former/Future State")
@Description(value={"Represents a value before an event happened or the value it will have directly after the event. If you use an expression that has different values before and after the event, the default value will usually be the value after the event.", "Note: The past, future and present of an expression are sometimes called 'time states' (I have to find a better word for this)."})
@Examples(value={"on teleport:", "\tformer world was \"world_nether\" # or 'world was'", "\tworld will be \"world\" # or 'world after the event is'", "on tool change:", "\tpast tool is an axe", "\tthe tool after the event will be air", "on weather change:", "\tset {%world%.old weather} to past weather", "\tset {%world.current weather} to the future weather"})
@Since(value="1.1")
public class ExprTimeState
extends WrapperExpression<Object> {
    static {
        Skript.registerExpression(ExprTimeState.class, Object.class, ExpressionType.PROPERTY, "[the] (former|past) [state] [of] %object%", "%object% before [the event]", "[the] (future|to-be) [state] [of] %object%", "%object%(-to-be| after[(wards| the event)])");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression<?> expr = vars[0];
        if (expr instanceof Literal) {
            return false;
        }
        if (isDelayed == Kleenean.TRUE) {
            Skript.error("Cannot use time states after the event has already passed", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        if (!expr.setTime(matchedPattern >= 2 ? 1 : -1)) {
            Skript.error(expr + " does not have a " + (matchedPattern >= 2 ? "future" : "past") + " state", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.setExpr(expr);
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the " + (this.getTime() == -1 ? "past" : "future") + " state of " + this.getExpr().toString(e, debug);
    }

    @Override
    public boolean setTime(int time) {
        return time == this.getTime();
    }
}

