/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.data.DefaultChangers;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.Time;
import ch.njol.util.Kleenean;
import org.bukkit.World;
import org.bukkit.event.Event;

@Name(value="Time")
@Description(value={"The <a href='../classes/#time'>time</a> of a world."})
@Examples(value={"time in world is between 18:00 and 6:00:", "\tbroadcast \"It's night-time, watch out for monsters!\""})
@Since(value="1.0")
public class ExprTime
extends PropertyExpression<World, Time> {
    static {
        Skript.registerExpression(ExprTime.class, Time.class, ExpressionType.PROPERTY, "[the] time [(in|of) %worlds%]", "%worlds%'[s] time");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Time[] get(Event e, World[] source) {
        return this.get(source, new Getter<Time, World>(){

            @Override
            public Time get(World w) {
                return new Time((int)w.getTime());
            }
        });
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return DefaultChangers.timeChanger.acceptChange(mode);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        DefaultChangers.timeChanger.change((World[])((World[])this.getExpr().getArray(e)), delta, mode);
    }

    @Override
    public Class<Time> getReturnType() {
        return Time.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the time in " + this.getExpr().toString(e, debug);
        }
        return Classes.getDebugMessage(this.getAll(e));
    }
}

