/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTargetEvent;

@Name(value="Target")
@Description(value={"For players this is the entity at the crosshair, while for mobs it represents the entity they are attacking/following (if any)."})
@Examples(value={"on entity target:", "    entity's target is a player", "    send \"You're being followed!\" to target of entity"})
@Since(value="")
public class ExprTarget
extends PropertyExpression<LivingEntity, Entity> {
    private EntityData<?> type;

    static {
        Skript.registerExpression(ExprTarget.class, Entity.class, ExpressionType.PROPERTY, "[the] target[[ed] %-*entitydata%] [of %livingentities%]", "%livingentities%'[s] target[[ed] %-*entitydata%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.type = exprs[matchedPattern] == null ? null : (EntityData)exprs[matchedPattern].getSingle(null);
        this.setExpr(exprs[1 - matchedPattern]);
        return true;
    }

    protected Entity[] get(Event e, LivingEntity[] source) {
        Entity en;
        if (this.getTime() >= 0 && e instanceof EntityTargetEvent && this.getExpr().isDefault() && !Delay.isDelayed(e) && (en = ((EntityTargetEvent)e).getTarget()) != null) {
            if (this.type != null && !this.type.isInstance(en)) {
                return (Entity[])Array.newInstance(this.getReturnType(), 0);
            }
            Entity[] r = (Entity[])Array.newInstance(this.getReturnType(), 1);
            r[0] = en;
            return r;
        }
        return this.get(source, new Converter<LivingEntity, Entity>(){

            @Override
            public Entity convert(LivingEntity en) {
                return Utils.getTarget(en, ExprTarget.this.type);
            }
        });
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.type == null ? Entity.class : this.type.getType();
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the target" + (this.type == null ? "" : "ed " + this.type) + " of " + this.getExpr().toString(e, debug);
        }
        return Classes.getDebugMessage(this.getAll(e));
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, EntityTargetEvent.class, this.getExpr());
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.SET) {
            return Utils.array(LivingEntity.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        if (this.getTime() >= 0 && e instanceof EntityTargetEvent && this.getExpr().isDefault() && !Delay.isDelayed(e)) {
            ((EntityTargetEvent)e).setTarget((Entity)((LivingEntity)delta));
            return;
        }
        LivingEntity target = (LivingEntity)delta;
        LivingEntity[] livingEntityArray = (LivingEntity[])this.getExpr().getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity entity = livingEntityArray[n2];
            if (entity instanceof Creature) {
                ((Creature)entity).setTarget(target);
            }
            ++n2;
        }
    }
}

