/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Speed")
@Description(value={"A player's walking or flying speed. Both can be changed, but values must be between -1 and 1 (excessive values will be changed to -1 or 1 respectively). Negative values reverse directions.", "Please note that changing a player's speed will change his FOV just like potions do."})
@Examples(value={"set the player's walk speed to 1", "increase the argument's fly speed by 0.1"})
@Since(value="")
public class ExprSpeed
extends SimplePropertyExpression<Player, Float> {
    private boolean walk;

    static {
        ExprSpeed.register(ExprSpeed.class, Float.class, "(0\u00a6walk[ing]|1\u00a6fl(y[ing]|ight))[( |-])speed", "players");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Skript.isRunningMinecraft(1, 4)) {
            Skript.error("fly and walk speed can only be used in Minecraft 1.4 and newer");
            return false;
        }
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.walk = parseResult.mark == 0;
        return true;
    }

    @Override
    public Float convert(Player p) {
        return Float.valueOf(this.walk ? p.getWalkSpeed() : p.getFlySpeed());
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Number.class};
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        float d = Math2.fit(-1.0f, ((Number)delta).floatValue(), 1.0f);
        Player[] playerArray = (Player[])this.getExpr().getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            if (this.walk) {
                p.setWalkSpeed(d);
            } else {
                p.setFlySpeed(d);
            }
            ++n2;
        }
    }

    @Override
    public Class<Float> getReturnType() {
        return Float.class;
    }

    @Override
    protected String getPropertyName() {
        return this.walk ? "walk speed" : "fly speed";
    }
}

