/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.CreeperData;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.entity.PlayerData;
import ch.njol.skript.entity.SkeletonData;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

@Name(value="Skull")
@Description(value={"Gets a skull item representing a player or an entity."})
@Examples(value={"give the victim's skull to the attacker", "set the block at the entity to the entity's skull"})
@Since(value="2.0")
public class ExprSkull
extends SimplePropertyExpression<Object, ItemStack> {
    static {
        ExprSkull.register(ExprSkull.class, ItemStack.class, "skull", "offlineplayers/entitydatas");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Skript.isRunningMinecraft(1, 4, 5)) {
            Skript.error("Skulls are only available in Bukkit 1.4.5+");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public ItemStack convert(Object e) {
        SkullType type;
        if (e instanceof SkeletonData) {
            type = ((SkeletonData)e).isWither() ? SkullType.WITHER : SkullType.SKELETON;
        } else if (e instanceof EntityData && Zombie.class.isAssignableFrom(((EntityData)e).getType())) {
            type = SkullType.ZOMBIE;
        } else if (e instanceof OfflinePlayer || e instanceof PlayerData) {
            type = SkullType.PLAYER;
        } else if (e instanceof CreeperData) {
            type = SkullType.CREEPER;
        } else {
            return null;
        }
        ItemStack is = new ItemStack(Material.SKULL_ITEM, 1, (short)type.ordinal());
        if (e instanceof OfflinePlayer) {
            SkullMeta s = (SkullMeta)is.getItemMeta();
            s.setOwner(((OfflinePlayer)e).getName());
            is.setItemMeta((ItemMeta)s);
        }
        return is;
    }

    @Override
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    @Override
    protected String getPropertyName() {
        return "skull";
    }
}

